/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.client.painter;

import dev.latvian.kubejs.client.painter.PainterObjectProperties;
import dev.latvian.kubejs.client.painter.PainterObjectStorage;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.SpecialEquality;
import net.minecraft.nbt.CompoundNBT;

public abstract class PainterObject
implements SpecialEquality {
    public String id = "";
    public PainterObjectStorage parent;
    public boolean visible = true;

    public PainterObject id(String i) {
        this.id = i;
        return this;
    }

    protected void load(PainterObjectProperties properties) {
        this.visible = properties.getBoolean("visible", this.visible);
    }

    public final void update(CompoundNBT tag) {
        if (tag.func_74767_n("remove")) {
            if (this.parent != null) {
                this.parent.remove(this.id);
            }
        } else {
            try {
                this.load(new PainterObjectProperties(tag));
            }
            catch (Exception ex) {
                ConsoleJS.CLIENT.error("Failed to update Painter object " + this.id + "/" + this.getClass().getSimpleName() + ": " + ex);
            }
        }
    }

    public boolean equals(Object o) {
        return o == this || o instanceof PainterObject && this.id.equals(((PainterObject)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    public boolean specialEquals(Object o, boolean shallow) {
        if (this == o || this.id == o) {
            return true;
        }
        if (o instanceof PainterObject) {
            return this.id.equals(((PainterObject)o).id);
        }
        if (o instanceof String) {
            return this.id.equals(this.toString());
        }
        return false;
    }
}

