/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.client;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSCommon;
import dev.latvian.kubejs.KubeJSPaths;
import dev.latvian.kubejs.KubeJSPlugin;
import dev.latvian.kubejs.client.ClientEventJS;
import dev.latvian.kubejs.client.ClientWrapper;
import dev.latvian.kubejs.client.KubeJSClientEventHandler;
import dev.latvian.kubejs.client.KubeJSResourcePackFinder;
import dev.latvian.kubejs.client.painter.Painter;
import dev.latvian.kubejs.net.NetworkEventJS;
import dev.latvian.kubejs.script.BindingsEvent;
import dev.latvian.kubejs.util.KubeJSPlugins;
import dev.latvian.kubejs.world.ClientWorldJS;
import dev.latvian.kubejs.world.WorldJS;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.shedaniel.architectury.hooks.PackRepositoryHooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.profiler.EmptyProfiler;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.Nullable;

public class KubeJSClient
extends KubeJSCommon {
    @Override
    public void init() {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        KubeJSClient.reloadClientScripts();
        new KubeJSClientEventHandler().init();
        ResourcePackList list = Minecraft.func_71410_x().func_195548_H();
        PackRepositoryHooks.addSource((ResourcePackList)list, (IPackFinder)new KubeJSResourcePackFinder());
        this.setup();
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::clientInit);
    }

    @Override
    public void reloadClientInternal() {
        KubeJSClient.reloadClientScripts();
    }

    public static void reloadClientScripts() {
        KubeJSClientEventHandler.staticItemTooltips = null;
        KubeJS.clientScriptManager.unload();
        KubeJS.clientScriptManager.loadFromDirectory();
        KubeJS.clientScriptManager.load();
    }

    public static void copyDefaultOptionsFile(File optionsFile) {
        Path defOptions;
        if (!optionsFile.exists() && Files.exists(defOptions = KubeJSPaths.CONFIG.resolve("defaultoptions.txt"), new LinkOption[0])) {
            try {
                KubeJS.LOGGER.info("Loaded default options from kubejs/config/defaultoptions.txt");
                Files.copy(defOptions, optionsFile.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void clientBindings(BindingsEvent event) {
        event.add("Client", new ClientWrapper());
        event.add("client", new ClientWrapper());
        event.add("Painter", Painter.INSTANCE);
    }

    @Override
    public void clientTypeWrappers(TypeWrappers typeWrappers) {
        typeWrappers.register(Unit.class, o -> {
            if (o instanceof Unit) {
                return (Unit)o;
            }
            if (o instanceof Number) {
                return FixedUnit.of((float)((Number)o).floatValue());
            }
            if (o instanceof String) {
                return Painter.INSTANCE.unitStorage.parse(o.toString());
            }
            return FixedUnit.ZERO;
        });
    }

    private void setup() {
        new ClientEventJS().post("client.init");
    }

    @Override
    public void handleDataToClientPacket(String channel, @Nullable CompoundNBT data) {
        new NetworkEventJS((PlayerEntity)Minecraft.func_71410_x().field_71439_g, channel, data).post("player.data_from_server", channel);
    }

    @Override
    @Nullable
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void paint(CompoundNBT tag) {
        Painter.INSTANCE.paint(tag);
    }

    @Override
    public WorldJS getClientWorld() {
        return ClientWorldJS.getInstance();
    }

    private void reload(IFutureReloadListener listener) {
        long start = System.currentTimeMillis();
        Minecraft mc = Minecraft.func_71410_x();
        listener.func_215226_a(CompletableFuture::completedFuture, mc.func_195551_G(), (IProfiler)EmptyProfiler.field_219906_a, (IProfiler)EmptyProfiler.field_219906_a, Util.func_215072_e(), (Executor)mc).thenAccept(unused -> mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Done! You still may have to reload all assets with F3 + T"), Util.field_240973_b_));
    }

    @Override
    public void reloadTextures() {
        this.reload((IFutureReloadListener)Minecraft.func_71410_x().func_110434_K());
    }

    @Override
    public void reloadLang() {
        this.reload((IFutureReloadListener)Minecraft.func_71410_x().func_135016_M());
    }

    @Override
    public boolean isClientButNotSelf(PlayerEntity player) {
        return player instanceof AbstractClientPlayerEntity && !(player instanceof ClientPlayerEntity);
    }
}

