/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block.forge;

import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MissingMappingEventJS<T extends IForgeRegistryEntry<T>>
extends EventJS {
    private final RegistryEvent.MissingMappings<T> event;
    private final Function<ResourceLocation, T> valueProvider;

    public MissingMappingEventJS(RegistryEvent.MissingMappings<T> e, Function<ResourceLocation, T> v) {
        this.event = e;
        this.valueProvider = v;
    }

    private void findMapping(ResourceLocation key, Consumer<RegistryEvent.MissingMappings.Mapping<T>> callback) {
        for (RegistryEvent.MissingMappings.Mapping mapping : this.event.getAllMappings()) {
            if (!mapping.key.equals((Object)key)) continue;
            callback.accept(mapping);
            return;
        }
    }

    public void remap(ResourceLocation key, ResourceLocation value) {
        this.findMapping(key, mapping -> {
            IForgeRegistryEntry to = (IForgeRegistryEntry)this.valueProvider.apply(value);
            if (to != null) {
                ConsoleJS.STARTUP.info("Remapping " + mapping.key + " to " + value + " (" + to.getClass() + ")");
                mapping.remap((IForgeRegistryEntry)UtilsJS.cast(to));
            }
        });
    }

    public void ignore(ResourceLocation key) {
        this.findMapping(key, RegistryEvent.MissingMappings.Mapping::ignore);
    }

    public void warn(ResourceLocation key) {
        this.findMapping(key, RegistryEvent.MissingMappings.Mapping::warn);
    }

    public void fail(ResourceLocation key) {
        this.findMapping(key, RegistryEvent.MissingMappings.Mapping::fail);
    }
}

