/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block;

import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.player.PlayerEventJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import me.shedaniel.architectury.utils.IntValue;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class BlockBreakEventJS
extends PlayerEventJS {
    private final ServerPlayerEntity entity;
    private final World world;
    private final BlockPos pos;
    private final BlockState state;
    @Nullable
    private final IntValue xp;

    public BlockBreakEventJS(ServerPlayerEntity entity, World world, BlockPos pos, BlockState state, @Nullable IntValue xp) {
        this.entity = entity;
        this.world = world;
        this.pos = pos;
        this.state = state;
        this.xp = xp;
    }

    @Override
    public boolean canCancel() {
        return true;
    }

    @Override
    public EntityJS getEntity() {
        return this.entityOf((Entity)this.entity);
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.world, this.pos){

            @Override
            public BlockState getBlockState() {
                return BlockBreakEventJS.this.state;
            }
        };
    }

    public int getXp() {
        if (this.xp == null) {
            return 0;
        }
        return this.xp.getAsInt();
    }

    public void setXp(int xp) {
        if (this.xp != null) {
            this.xp.accept(xp);
        }
    }
}

