/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs;

import dev.latvian.kubejs.CommonProperties;
import dev.latvian.kubejs.KubeJSCommon;
import dev.latvian.kubejs.KubeJSOtherEventHandler;
import dev.latvian.kubejs.KubeJSPaths;
import dev.latvian.kubejs.KubeJSPlugin;
import dev.latvian.kubejs.block.KubeJSBlockEventHandler;
import dev.latvian.kubejs.client.KubeJSClient;
import dev.latvian.kubejs.entity.KubeJSEntityEventHandler;
import dev.latvian.kubejs.event.StartupEventJS;
import dev.latvian.kubejs.fluid.KubeJSFluidEventHandler;
import dev.latvian.kubejs.item.KubeJSItemEventHandler;
import dev.latvian.kubejs.net.KubeJSNet;
import dev.latvian.kubejs.player.KubeJSPlayerEventHandler;
import dev.latvian.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.kubejs.script.ScriptFileInfo;
import dev.latvian.kubejs.script.ScriptManager;
import dev.latvian.kubejs.script.ScriptPack;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.script.ScriptsLoadedEvent;
import dev.latvian.kubejs.server.KubeJSServerEventHandler;
import dev.latvian.kubejs.util.KubeJSBackgroundThread;
import dev.latvian.kubejs.util.KubeJSPlugins;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.KubeJSWorldEventHandler;
import dev.latvian.kubejs.world.gen.FlatChunkGeneratorKJS;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import me.shedaniel.architectury.platform.Mod;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.CreativeTabs;
import me.shedaniel.architectury.utils.EnvExecutor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KubeJS {
    public static final String MOD_ID = "kubejs";
    public static final String MOD_NAME = "KubeJS";
    public static final Logger LOGGER = LogManager.getLogger((String)"KubeJS");
    public static KubeJS instance;
    public static KubeJSCommon PROXY;
    public static boolean nextClientHasClientMod;
    public static ItemGroup tab;
    public static ScriptManager startupScriptManager;
    public static ScriptManager clientScriptManager;

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public KubeJS() throws Throwable {
        instance = this;
        Locale.setDefault(Locale.US);
        new KubeJSBackgroundThread().start();
        if (Files.notExists(KubeJSPaths.README, new LinkOption[0])) {
            UtilsJS.tryIO(() -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add("Find more info on the website: https://kubejs.com/");
                list.add("");
                list.add("Directory information:");
                list.add("");
                list.add("assets - Acts as a resource pack, you can put any client resources in here, like textures, models, etc. Example: assets/kubejs/textures/item/test_item.png");
                list.add("data - Acts as a datapack, you can put any server resources in here, like loot tables, functions, etc. Example: data/kubejs/loot_tables/blocks/test_block.json");
                list.add("");
                list.add("startup_scripts - Scripts that get loaded once during game startup - Used for adding items and other things that can only happen while the game is loading (Can be reloaded with /kubejs reload_startup_scripts, but it may not work!)");
                list.add("server_scripts - Scripts that get loaded every time server resources reload - Used for modifying recipes, tags, loot tables, and handling server events (Can be reloaded with /reload)");
                list.add("client_scripts - Scripts that get loaded every time client resources reload - Used for JEI events, tooltips and other client side things (Can be reloaded with F3+T)");
                list.add("");
                list.add("config - KubeJS config storage. This is also the only directory that scripts can access other than world directory");
                list.add("exported - Data dumps like texture atlases end up here");
                list.add("");
                list.add("You can find type-specific logs in logs/kubejs/ directory");
                Files.write(KubeJSPaths.README, list, new OpenOption[0]);
            });
        }
        PROXY = (KubeJSCommon)EnvExecutor.getEnvSpecific(() -> KubeJSClient::new, () -> KubeJSCommon::new);
        long now = System.currentTimeMillis();
        LOGGER.info("Looking for KubeJS plugins...");
        for (Mod mod : Platform.getMods()) {
            try {
                KubeJSPlugins.load(mod.getModId(), mod.getFilePath());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        LOGGER.info("Done in " + (System.currentTimeMillis() - now) / 1000L + " s");
        startupScriptManager = new ScriptManager(ScriptType.STARTUP, KubeJSPaths.STARTUP_SCRIPTS, "/data/kubejs/example_startup_script.js");
        clientScriptManager = new ScriptManager(ScriptType.CLIENT, KubeJSPaths.CLIENT_SCRIPTS, "/data/kubejs/example_client_script.js");
        Path oldStartupFolder = KubeJSPaths.DIRECTORY.resolve("startup");
        if (Files.exists(oldStartupFolder, new LinkOption[0])) {
            UtilsJS.tryIO(() -> Files.move(oldStartupFolder, KubeJSPaths.STARTUP_SCRIPTS, new CopyOption[0]));
        }
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::init);
        if (!CommonProperties.get().serverOnly) {
            tab = CreativeTabs.create((ResourceLocation)new ResourceLocation(MOD_ID, MOD_ID), () -> new ItemStack((IItemProvider)Items.field_196126_bm));
        }
        startupScriptManager.unload();
        startupScriptManager.loadFromDirectory();
        startupScriptManager.load();
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::initStartup);
        KubeJSOtherEventHandler.init();
        KubeJSWorldEventHandler.init();
        KubeJSPlayerEventHandler.init();
        KubeJSEntityEventHandler.init();
        KubeJSBlockEventHandler.init();
        KubeJSItemEventHandler.init();
        KubeJSFluidEventHandler.init();
        KubeJSServerEventHandler.init();
        KubeJSRecipeEventHandler.init();
        PROXY.init();
    }

    public static void loadScripts(ScriptPack pack, Path dir, String path) {
        if (!path.isEmpty() && !path.endsWith("/")) {
            path = path + "/";
        }
        String pathPrefix = path;
        UtilsJS.tryIO(() -> Files.walk(dir, 10, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
            String fileName = dir.relativize((Path)file).toString().replace(File.separatorChar, '/');
            if (fileName.endsWith(".js")) {
                pack.info.scripts.add(new ScriptFileInfo(pack.info, pathPrefix + fileName));
            }
        }));
    }

    public static String appendModId(String id) {
        return id.indexOf(58) == -1 ? "kubejs:" + id : id;
    }

    public static Path getGameDirectory() {
        return Platform.getGameFolder();
    }

    public static Path verifyFilePath(Path path) throws IOException {
        if (!path.normalize().toAbsolutePath().startsWith(KubeJS.getGameDirectory())) {
            throw new IOException("You can't access files outside Minecraft directory!");
        }
        return path;
    }

    public static void verifyFilePath(File file) throws IOException {
        KubeJS.verifyFilePath(file.toPath());
    }

    public void setup() {
        UtilsJS.init();
        KubeJSNet.init();
        new StartupEventJS().post(ScriptType.STARTUP, "init");
        Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation(MOD_ID, "flat"), FlatChunkGeneratorKJS.CODEC);
    }

    public void loadComplete() {
        KubeJSPlugins.forEachPlugin(KubeJSPlugin::afterInit);
        ((Runnable)ScriptsLoadedEvent.EVENT.invoker()).run();
        new StartupEventJS().post(ScriptType.STARTUP, "postinit");
        UtilsJS.postModificationEvents();
    }

    static {
        nextClientHasClientMod = false;
        tab = ItemGroup.field_78026_f;
    }
}

