/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.create;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.simibubi.create.content.contraptions.itemAssembly.IAssemblyRecipe;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import net.minecraft.item.crafting.IRecipe;

public class SequencedAssemblyRecipeJS
extends RecipeJS {
    public void create(ListJS args) {
        this.outputItems.addAll(this.parseResultItemList(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)));
        this.json.add("transitionalItem", ItemStackJS.of((Object)"create:precision_mechanism").toResultJson());
        this.json.addProperty("loops", (Number)4);
        JsonArray sequence = new JsonArray();
        for (Object o : ListJS.orSelf((Object)args.get(2))) {
            if (o instanceof RecipeJS) {
                ((RecipeJS)o).dontAdd();
                try {
                    IRecipe r = ((RecipeJS)o).createRecipe();
                    if (r instanceof IAssemblyRecipe && r instanceof ProcessingRecipe && ((IAssemblyRecipe)r).supportsAssembly()) {
                        sequence.add((JsonElement)new SequencedRecipe((ProcessingRecipe)r).toJson());
                        continue;
                    }
                    throw new RecipeExceptionJS("Sequence recipe must be an assembly recipe!");
                }
                catch (Throwable ex) {
                    throw new RecipeExceptionJS("Failed to create " + ex);
                }
            }
            throw new RecipeExceptionJS("Object must be a recipe, instead got " + o + " / " + o.getClass().getName());
        }
        this.json.add("sequence", (JsonElement)sequence);
    }

    public void deserialize() {
        this.outputItems.addAll(this.parseResultItemList(this.json.get("results")));
        this.inputItems.add(this.parseIngredientItem(this.json.get("ingredient")));
    }

    public SequencedAssemblyRecipeJS transitionalItem(ItemStackJS item) {
        this.json.add("transitionalItem", item.toResultJson());
        this.save();
        return this;
    }

    public SequencedAssemblyRecipeJS loops(int loops) {
        this.json.addProperty("loops", (Number)loops);
        this.save();
        return this;
    }

    public void serialize() {
        if (this.serializeOutputs) {
            JsonArray array = new JsonArray();
            for (ItemStackJS out : this.outputItems) {
                array.add(out.toResultJson());
            }
            this.json.add("results", (JsonElement)array);
        }
        if (this.serializeInputs) {
            this.json.add("ingredient", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
    }
}

