/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.bloodmagic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.bloodmagic.BMRecipeJS;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.util.ListJS;

public class ArcRecipeJS
extends BMRecipeJS {
    public void create(ListJS args) {
        this.outputItems.add(this.parseResultItem(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)));
        this.inputItems.add(this.parseIngredientItem(args.get(2)));
        if (args.size() >= 4) {
            this.outputItems.addAll(this.parseResultItemList(args.get(3)));
        }
        this.json.addProperty("consumeingredient", Boolean.valueOf(true));
    }

    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("output")));
        this.inputItems.add(this.parseIngredientItem(this.json.get("input")));
        this.inputItems.add(this.parseIngredientItem(this.json.get("tool")));
        if (this.json.has("addedoutput")) {
            for (JsonElement e : this.json.get("addedoutput").getAsJsonArray()) {
                JsonObject o = e.getAsJsonObject();
                this.outputItems.add(this.parseResultItem(o.get("type")).chance(o.get("chance").getAsDouble()));
            }
        }
    }

    public ArcRecipeJS consumeIngredient(boolean v) {
        this.json.addProperty("consumeingredient", Boolean.valueOf(v));
        this.save();
        return this;
    }

    public ArcRecipeJS outputFluid(Object o) {
        this.json.add("outputfluid", (JsonElement)FluidStackJS.of((Object)o).toJson());
        this.save();
        return this;
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("output", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
            if (this.outputItems.size() > 1) {
                JsonArray array = new JsonArray();
                for (int i = 1; i < this.outputItems.size(); ++i) {
                    ItemStackJS is = (ItemStackJS)this.outputItems.get(i);
                    JsonObject o = new JsonObject();
                    o.add("type", is.toResultJson());
                    o.addProperty("chance", (Number)(is.hasChance() ? is.getChance() : 1.0));
                    array.add((JsonElement)o);
                }
                this.json.add("addedoutput", (JsonElement)array);
            }
        }
        if (this.serializeInputs) {
            this.json.add("input", ((IngredientJS)this.inputItems.get(0)).toJson());
            this.json.add("tool", ((IngredientJS)this.inputItems.get(1)).toJson());
        }
    }
}

