/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.kotlinforforge.forge;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.UninitializedPropertyAccessException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.kotlinforforge.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 )*\u0010\b\u0000\u0010\u0001*\n\u0012\u0006\b\u0000\u0012\u0002H\u00010\u00022\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u0002H\u00010\u00032\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\b\u0012\u0004\u0012\u0002H\u00010\b2\b\u0012\u0004\u0012\u0002H\u00010\t:\u0001)B\u0019\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\r\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\fH\u00c6\u0003J'\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\n\u001a\u00020\u00072\f\b\u0002\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u00d6\u0003J\r\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ$\u0010\u001f\u001a\u00028\u00002\b\u0010 \u001a\u0004\u0018\u00010\u00042\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0096\u0002\u00a2\u0006\u0002\u0010#J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u000e\u0010&\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u00028\u0000X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006*"}, d2={"Lthedarkcolour/kotlinforforge/forge/ObjectHolderDelegate;", "T", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "Lkotlin/properties/ReadOnlyProperty;", "", "Ljava/util/function/Consumer;", "Ljava/util/function/Predicate;", "Lnet/minecraft/util/ResourceLocation;", "Ljava/util/function/Supplier;", "Lkotlin/Function0;", "registryName", "registry", "Lnet/minecraftforge/registries/IForgeRegistry;", "(Lnet/minecraft/util/ResourceLocation;Lnet/minecraftforge/registries/IForgeRegistry;)V", "getRegistry", "()Lnet/minecraftforge/registries/IForgeRegistry;", "getRegistryName", "()Lnet/minecraft/util/ResourceLocation;", "value", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "accept", "", "filter", "component1", "component2", "copy", "equals", "", "other", "get", "()Lnet/minecraftforge/registries/IForgeRegistryEntry;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Lnet/minecraftforge/registries/IForgeRegistryEntry;", "hashCode", "", "invoke", "toString", "", "Companion", "kotlinforforge"})
public final class ObjectHolderDelegate<T extends IForgeRegistryEntry<? super T>>
implements ReadOnlyProperty<Object, T>,
Consumer<Predicate<ResourceLocation>>,
Supplier<T>,
Function0<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation registryName;
    @NotNull
    private final IForgeRegistry<?> registry;
    private T value;
    @NotNull
    private static final HashMap<Class<?>, IForgeRegistry<?>> TYPE_2_REGISTRY = new HashMap();

    public ObjectHolderDelegate(@NotNull ResourceLocation registryName, @NotNull IForgeRegistry<?> registry) {
        Intrinsics.checkNotNullParameter(registryName, "registryName");
        Intrinsics.checkNotNullParameter(registry, "registry");
        this.registryName = registryName;
        this.registry = registry;
        ObjectHolderRegistry.addHandler((Consumer)this);
    }

    @NotNull
    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @NotNull
    public final IForgeRegistry<?> getRegistry() {
        return this.registry;
    }

    @Override
    @NotNull
    public T get() {
        T t;
        if (this.value != null) {
            t = this.value;
            if (t == null) {
                Intrinsics.throwUninitializedPropertyAccessException("value");
                t = null;
            }
        } else {
            throw new UninitializedPropertyAccessException("ObjectHolderDelegate " + this.registryName + " of type " + this.registry.getRegistryName() + " has not been initialized");
        }
        return t;
    }

    @Override
    @NotNull
    public T getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, "property");
        return this.get();
    }

    @Override
    @NotNull
    public T invoke() {
        return this.get();
    }

    @Override
    public void accept(@NotNull Predicate<ResourceLocation> filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        if (!filter2.test(this.registry.getRegistryName())) {
            return;
        }
        if (this.registry.containsKey(this.registryName)) {
            IForgeRegistryEntry tempValue = this.registry.getValue(this.registryName);
            if (tempValue != null) {
                this.value = tempValue;
            } else {
                LoggerKt.getLOGGER().debug("Unable to lookup value for " + this + ", likely just mod options.");
            }
        }
    }

    @NotNull
    public final ResourceLocation component1() {
        return this.registryName;
    }

    @NotNull
    public final IForgeRegistry<?> component2() {
        return this.registry;
    }

    @NotNull
    public final ObjectHolderDelegate<T> copy(@NotNull ResourceLocation registryName, @NotNull IForgeRegistry<?> registry) {
        Intrinsics.checkNotNullParameter(registryName, "registryName");
        Intrinsics.checkNotNullParameter(registry, "registry");
        return new ObjectHolderDelegate<T>(registryName, registry);
    }

    public static /* synthetic */ ObjectHolderDelegate copy$default(ObjectHolderDelegate objectHolderDelegate, ResourceLocation resourceLocation, IForgeRegistry iForgeRegistry, int n, Object object) {
        if ((n & 1) != 0) {
            resourceLocation = objectHolderDelegate.registryName;
        }
        if ((n & 2) != 0) {
            iForgeRegistry = objectHolderDelegate.registry;
        }
        return objectHolderDelegate.copy(resourceLocation, iForgeRegistry);
    }

    @NotNull
    public String toString() {
        return "ObjectHolderDelegate(registryName=" + this.registryName + ", registry=" + this.registry + ')';
    }

    public int hashCode() {
        int result2 = this.registryName.hashCode();
        result2 = result2 * 31 + this.registry.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ObjectHolderDelegate)) {
            return false;
        }
        ObjectHolderDelegate objectHolderDelegate = (ObjectHolderDelegate)other;
        if (!Intrinsics.areEqual(this.registryName, objectHolderDelegate.registryName)) {
            return false;
        }
        return Intrinsics.areEqual(this.registry, objectHolderDelegate.registry);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0016\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0005R\"\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lthedarkcolour/kotlinforforge/forge/ObjectHolderDelegate$Companion;", "", "()V", "TYPE_2_REGISTRY", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lnet/minecraftforge/registries/IForgeRegistry;", "findRegistry", "clazz", "getRegistry", "kotlinforforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IForgeRegistry<?> getRegistry(@NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, "clazz");
            IForgeRegistry iForgeRegistry = TYPE_2_REGISTRY.computeIfAbsent(clazz, this::findRegistry);
            Intrinsics.checkNotNullExpressionValue(iForgeRegistry, "TYPE_2_REGISTRY.computeI\u2026nt(clazz, ::findRegistry)");
            return iForgeRegistry;
        }

        private final IForgeRegistry<?> findRegistry(Class<?> clazz) {
            LinkedList typeQueue = new LinkedList();
            IForgeRegistry registry = null;
            typeQueue.add(clazz);
            while (!((Collection)typeQueue).isEmpty() && registry == null) {
                Class type2 = (Class)typeQueue.remove();
                Collection collection = typeQueue;
                Class<?>[] classArray = type2.getInterfaces();
                Intrinsics.checkNotNullExpressionValue(classArray, "type.interfaces");
                CollectionsKt.addAll(collection, (Object[])classArray);
                if (!IForgeRegistryEntry.class.isAssignableFrom(type2)) continue;
                registry = RegistryManager.ACTIVE.getRegistry(type2);
                Class parent = type2.getSuperclass();
                if (parent == null) continue;
                typeQueue.add(parent);
            }
            IForgeRegistry iForgeRegistry = registry;
            if (iForgeRegistry == null) {
                throw new IllegalArgumentException("ObjectHolderDelegate must represent a type that implements IForgeRegistryEntry");
            }
            return iForgeRegistry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

