/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.collection.TradeList;
import jeresources.compatibility.CompatBase;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;

public class VillagerEntry {
    private final List<TradeList> tradeList;
    private final VillagerProfession profession;

    public VillagerEntry(VillagerProfession profession, Int2ObjectMap<VillagerTrades.ITrade[]> tradesLists) {
        this.profession = profession;
        this.tradeList = new LinkedList<TradeList>();
        this.addITradeLists(tradesLists);
    }

    public void addITradeLists(Int2ObjectMap<VillagerTrades.ITrade[]> tradesLists) {
        for (int i = 1; i < tradesLists.size() + 1; ++i) {
            VillagerTrades.ITrade[] levelList = (VillagerTrades.ITrade[])tradesLists.get(i);
            TradeList trades = this.tradeList.size() > i ? this.tradeList.get(i) : new TradeList(this);
            trades.addITradeList(levelList);
            this.tradeList.add(trades);
        }
    }

    public TradeList getVillagerTrades(int level) {
        if (this.tradeList.size() > level) {
            return this.tradeList.get(level);
        }
        return new TradeList(null);
    }

    public List<ItemStack> getInputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            for (TradeList.Trade trade : list2) {
                list.add(trade.getMinCostA());
                if (trade.getMinCostB().func_190926_b()) continue;
                list.add(trade.getMinCostB());
            }
        }
        return list;
    }

    public List<ItemStack> getOutputs() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (List list2 : this.tradeList) {
            list.addAll(list2.stream().map(TradeList.Trade::getMinResult).collect(Collectors.toList()));
        }
        return list;
    }

    public int getMaxLevel() {
        return this.tradeList.size();
    }

    public String getName() {
        return this.profession.toString();
    }

    public String getDisplayName() {
        return "entity.minecraft.villager." + this.profession.toString();
    }

    public VillagerProfession getProfession() {
        return this.profession;
    }

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (int i = 0; i < this.tradeList.size(); ++i) {
            if (this.tradeList.get(i) == null || this.tradeList.get(i).getFocusedList(focus).size() <= 0) continue;
            levels.add(i);
        }
        return levels;
    }

    public VillagerEntity getVillagerEntity() {
        VillagerEntity villagerEntity = (VillagerEntity)EntityType.field_200756_av.func_200721_a(CompatBase.getWorld());
        villagerEntity.func_213753_a(villagerEntity.func_213700_eh().func_221126_a(this.profession));
        return villagerEntity;
    }
}

