/*
 * Decompiled with CFR 0.152.
 */
package jeresources.api.util;

import java.util.Random;
import java.util.stream.IntStream;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.ICustomLootFunction;
import jeresources.api.drop.LootDrop;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.EnchantRandomly;
import net.minecraft.loot.functions.EnchantWithLevels;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.SetDamage;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.util.math.MathHelper;

public class LootFunctionHelper {
    private static final Random rand = new Random();
    private static final int STATISTICAL_TEST = 100;

    public static void applyFunction(ILootFunction lootFunction, LootDrop lootDrop) {
        if (lootFunction instanceof SetCount) {
            lootDrop.minDrop = LootFunctionHelper.getMin(((SetCount)lootFunction).field_186568_a);
            if (lootDrop.minDrop < 0) {
                lootDrop.minDrop = 0;
            }
            lootDrop.item.func_190920_e(Math.max(lootDrop.minDrop, 1));
            lootDrop.maxDrop = LootFunctionHelper.getMax(((SetCount)lootFunction).field_186568_a);
        } else if (lootFunction instanceof SetDamage) {
            lootDrop.item.func_196085_b(MathHelper.func_76141_d((float)((SetDamage)lootFunction).field_186566_b.func_186509_a()));
        } else if (lootFunction instanceof EnchantRandomly || lootFunction instanceof EnchantWithLevels) {
            lootDrop.enchanted = true;
        } else if (!(lootFunction instanceof Smelt)) {
            if (lootFunction instanceof LootingEnchantBonus) {
                lootDrop.addConditional(Conditional.affectedByLooting);
            } else if (lootFunction instanceof ICustomLootFunction) {
                ((ICustomLootFunction)lootFunction).apply(lootDrop);
            } else {
                try {
                    lootDrop.item = (ItemStack)lootFunction.apply((Object)lootDrop.item, null);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static int getMin(IRandomRange randomRange) {
        if (randomRange instanceof ConstantRange) {
            return randomRange.func_186511_a(rand);
        }
        if (randomRange instanceof RandomValueRange) {
            return MathHelper.func_76141_d((float)((RandomValueRange)randomRange).func_186509_a());
        }
        if (randomRange instanceof BinomialRange) {
            return 0;
        }
        return IntStream.iterate(0, i -> randomRange.func_186511_a(rand)).limit(100L).min().orElse(0);
    }

    public static int getMax(IRandomRange randomRange) {
        if (randomRange instanceof ConstantRange) {
            return randomRange.func_186511_a(rand);
        }
        if (randomRange instanceof RandomValueRange) {
            return MathHelper.func_76141_d((float)((RandomValueRange)randomRange).func_186512_b());
        }
        if (randomRange instanceof BinomialRange) {
            return ((BinomialRange)randomRange).field_215841_d;
        }
        return IntStream.iterate(0, i -> randomRange.func_186511_a(rand)).limit(100L).max().orElse(0);
    }
}

