/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.jei;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.CostList;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.guis.GuiRecipe;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.utils.wrappers.Trio;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public class JecaPlugin
implements IModPlugin {
    public static IJeiRuntime runtime;

    public static ILabel getLabelUnderMouse() {
        Wrapper<Object> o = new Wrapper<Object>(null);
        o.push(runtime.getIngredientListOverlay().getIngredientUnderMouse());
        o.push(runtime.getBookmarkOverlay().getIngredientUnderMouse());
        return ILabel.Converter.from(o.value);
    }

    public static boolean isFocused() {
        return runtime.getIngredientListOverlay().hasKeyboardFocus();
    }

    public static void showRecipe(ILabel l) {
        Object rep = l.getRepresentation();
        if (rep != null) {
            runtime.getRecipesGui().show(runtime.getRecipeManager().createFocus(IFocus.Mode.OUTPUT, rep));
        }
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jecalculation", "general");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)new TransferHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public static class TransferHandler
    implements IRecipeTransferHandler<JecaGui.ContainerTransfer> {
        public Class<JecaGui.ContainerTransfer> getContainerClass() {
            return JecaGui.ContainerTransfer.class;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(JecaGui.ContainerTransfer container, IRecipeLayout layout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
            if (doTransfer) {
                Class<?> context = layout.getRecipeCategory().getClass();
                JecaGui gui = container.getGui();
                if (gui.root instanceof GuiRecipe) {
                    ((GuiRecipe)gui.root).transfer(TransferHandler.convertRecipe(layout, context), context);
                } else {
                    GuiRecipe guiRecipe = new GuiRecipe();
                    JecaGui.displayGui((IGui)guiRecipe, JecaGui.getLast());
                    guiRecipe.transfer(TransferHandler.convertRecipe(layout, context), context);
                }
            }
            return null;
        }

        private static EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> convertRecipe(IRecipeLayout recipe, Class<?> context) {
            EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> merged = new EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>>(Recipe.IO.class);
            ArrayList<IIngredientType> types = new ArrayList<IIngredientType>();
            for (IIngredientType i2 : runtime.getIngredientManager().getRegisteredIngredientTypes()) {
                types.add(i2);
            }
            types.stream().map(arg_0 -> ((IRecipeLayout)recipe).getIngredientsGroup(arg_0)).flatMap(i -> i.getGuiIngredients().values().stream()).forEach(i -> TransferHandler.merge(merged, i.getAllIngredients(), context, Recipe.IO.isInput(i.isInput())));
            List catalysts = runtime.getRecipeManager().getRecipeCatalysts(recipe.getRecipeCategory());
            TransferHandler.merge(merged, catalysts, context, Recipe.IO.CATALYST);
            return merged;
        }

        private static void merge(EnumMap<Recipe.IO, List<Trio<ILabel, CostList, CostList>>> dst, List<?> objs, Class<?> context, Recipe.IO type) {
            List<ILabel> list = objs.stream().map(ILabel.Converter::from).collect(Collectors.toList());
            if (list.isEmpty()) {
                return;
            }
            ILabel rep = ((ILabel)list.get(0)).copy();
            if (type == Recipe.IO.INPUT && list.size() != 1) {
                rep = ILabel.CONVERTER.first(list, context);
            }
            ILabel fin = rep;
            dst.computeIfAbsent(type, i -> new ArrayList()).stream().filter(p -> {
                CostList cl = new CostList(list);
                if (((CostList)p.three).equals(cl)) {
                    ILabel.MERGER.merge((ILabel)p.one, fin).ifPresent(i -> {
                        p.one = i;
                        Object cfr_ignored_0 = p.one;
                    });
                    p.two = ((CostList)p.two).merge(cl, true, false);
                    return true;
                }
                return false;
            }).findAny().orElseGet(() -> {
                Trio<ILabel, CostList, CostList> ret = new Trio<ILabel, CostList, CostList>(fin, new CostList(list), new CostList(list));
                ((List)dst.get((Object)type)).add(ret);
                return ret;
            });
        }
    }
}

