/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.utils.wrappers.Wrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IWidget {
    default public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        return false;
    }

    default public boolean onTooltip(JecaGui gui, int xMouse, int yMouse, List<String> tooltip) {
        return false;
    }

    default public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        return false;
    }

    default public void onMouseFocused(JecaGui gui, int xMouse, int yMouse, int button) {
    }

    default public boolean onMouseDragged(JecaGui gui, int xMouse, int yMouse, int xDrag, int yDrag) {
        return false;
    }

    default public boolean onMouseReleased(JecaGui gui, int xMouse, int yMouse, int button) {
        return false;
    }

    default public boolean onKeyPressed(JecaGui gui, int key, int modifier) {
        return false;
    }

    default public boolean onKeyReleased(JecaGui gui, int key, int modifier) {
        return false;
    }

    default public boolean onChar(JecaGui gui, char ch, int modifier) {
        return false;
    }

    default public boolean onMouseScroll(JecaGui gui, int xMouse, int yMouse, int diff) {
        return false;
    }

    default public boolean getLabelUnderMouse(int xMouse, int yMouse, Wrapper<ILabel> label) {
        return false;
    }

    default public void onTick(JecaGui gui) {
    }

    @FunctionalInterface
    public static interface ListenerAction<W extends IWidget> {
        public void invoke(W var1);
    }

    @FunctionalInterface
    public static interface ListenerValue<W extends IWidget, V> {
        public void invoke(W var1, V var2);
    }
}

