/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis.pickers;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.gui.guis.pickers.IPicker;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WLabel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class PickerItemStack
extends IPicker.Impl
implements IGui {
    WLabel label = new WLabel(7, 7, 20, 20, true).setLsnrUpdate((i, v) -> this.update((ILabel)v));
    WButton bConfirm = new WButtonIcon(149, 7, 20, 20, Resource.BTN_YES, "item_stack.confirm").setListener(i -> this.callback.accept(this.label.getLabel()));
    WButton bNbtN = new WButtonIcon(49, 7, 20, 20, Resource.BTN_NBT_N, "item_stack.nbt_normal").setListener(i -> this.setFNbt(true));
    WButton bNbtF = new WButtonIcon(49, 7, 20, 20, Resource.BTN_NBT_F, "item_stack.nbt_fuzzy").setListener(i -> this.setFNbt(false));
    WButton bCapN = new WButtonIcon(68, 7, 20, 20, Resource.BTN_CAP_N, "item_stack.capability_normal").setListener(i -> this.setFCap(true));
    WButton bCapF = new WButtonIcon(68, 7, 20, 20, Resource.BTN_CAP_F, "item_stack.capability_fuzzy").setListener(i -> this.setFCap(false));
    WButton bMetaN = new WButtonIcon(30, 7, 20, 20, Resource.BTN_META_N, "item_stack.meta_normal").setListener(i -> this.setFMeta(true));
    WButton bMetaF = new WButtonIcon(30, 7, 20, 20, Resource.BTN_META_F, "item_stack.meta_fuzzy").setListener(i -> this.setFMeta(false));
    ILabel raw = ILabel.EMPTY;
    boolean fMeta;
    boolean fNbt;
    boolean fCap = false;

    public PickerItemStack() {
        this.add(this.label, this.bConfirm);
        this.update(ILabel.EMPTY);
    }

    @Override
    public boolean acceptsLabel() {
        return true;
    }

    public void update(ILabel l) {
        this.raw = l;
        this.setFCap(false);
        this.setFMeta(false);
        this.setFNbt(false);
        boolean b = l == ILabel.EMPTY;
        this.bNbtN.setDisabled(b);
        this.bCapN.setDisabled(b);
        this.bMetaN.setDisabled(b);
        this.bConfirm.setDisabled(b);
    }

    private void setFNbt(boolean b) {
        this.setF(b, this.bNbtN, this.bNbtF, () -> {
            this.fNbt = b;
        });
    }

    private void setFMeta(boolean b) {
        this.setF(b, this.bMetaN, this.bMetaF, () -> {
            this.fMeta = b;
        });
    }

    private void setFCap(boolean b) {
        this.setF(b, this.bCapN, this.bCapF, () -> {
            this.fCap = b;
        });
    }

    private void setF(boolean b, WButton be, WButton bd, Runnable r) {
        this.remove(be, bd);
        if (b) {
            this.add(bd);
        } else {
            this.add(be);
        }
        r.run();
        if (this.raw instanceof LItemStack) {
            LItemStack lis = (LItemStack)this.raw;
            this.label.setLabel(lis.copy().setFCap(this.fCap).setFMeta(this.fMeta).setFNbt(this.fNbt));
        }
    }
}

