/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.IRecord;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class RecordCraft
implements IRecord {
    public static final String KEY_RECENTS = "recents";
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_INVENTORY = "inventory";
    public static final String KEY_MODE = "mode";
    Utilities.Recent<ILabel> record = new Utilities.Recent<ILabel>((a, b) -> a == ILabel.EMPTY || a.equals(b), 9);
    public String amount;
    public boolean inventory;
    public Mode mode;

    public RecordCraft(CompoundNBT nbt) {
        List ls = nbt.func_150295_c(KEY_RECENTS, 10).stream().filter(n -> n instanceof CompoundNBT).map(n -> ILabel.SERIALIZER.deserialize((CompoundNBT)n)).collect(Collectors.toList());
        new Utilities.ReversedIterator(ls).forEachRemaining(l -> this.record.push((ILabel)l, false));
        this.amount = nbt.func_74779_i(KEY_AMOUNT);
        this.inventory = nbt.func_74767_n(KEY_INVENTORY);
        String s = nbt.func_74779_i(KEY_MODE);
        this.mode = Mode.INPUT;
        for (Mode m : Mode.values()) {
            if (!s.equals(m.toString().toLowerCase())) continue;
            this.mode = m;
        }
    }

    public boolean push(ILabel label, boolean replace) {
        return this.record.push(label, replace);
    }

    public ILabel getLatest() {
        return this.record.size() == 0 ? ILabel.EMPTY : this.record.toList().get(0);
    }

    public List<ILabel> getHistory() {
        return this.record.size() > 1 ? this.record.toList().subList(1, this.record.size()) : new ArrayList<ILabel>();
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT ret = new CompoundNBT();
        ret.func_74757_a(KEY_INVENTORY, this.inventory);
        ret.func_74778_a(KEY_AMOUNT, this.amount);
        ListNBT recent = new ListNBT();
        this.record.toList().forEach(l -> recent.add((Object)ILabel.SERIALIZER.serialize((ILabel)l)));
        ret.func_218657_a(KEY_RECENTS, (INBT)recent);
        ret.func_74778_a(KEY_MODE, this.mode.toString().toLowerCase());
        return ret;
    }

    public static enum Mode {
        INPUT,
        OUTPUT,
        CATALYST,
        STEPS;

    }
}

