/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.labels.LPlaceholder;
import me.towdium.jecalculation.data.structure.RecordPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class JecaCapability {
    @CapabilityInject(value=Container.class)
    public static final Capability<Container> CAPABILITY_RECORD = null;

    public static RecordPlayer getRecord(PlayerEntity player) {
        return ((Container)player.getCapability(CAPABILITY_RECORD, Direction.UP).orElseGet(Container::new)).getRecord();
    }

    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof ServerPlayerEntity) {
            e.addCapability(new ResourceLocation("jecalculation", "record"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public static void onCloneCapability(PlayerEvent.Clone e) {
        RecordPlayer r = JecaCapability.getRecord(e.getOriginal());
        ((Container)e.getPlayer().getCapability(CAPABILITY_RECORD, Direction.UP).orElseGet(Container::new)).setRecord(r);
    }

    public static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundNBT> {
        Container container = new Container();

        public CompoundNBT serializeNBT() {
            return this.container.getRecord().serialize();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            boolean s = LPlaceholder.state;
            LPlaceholder.state = false;
            this.container.setRecord(new RecordPlayer(nbt));
            LPlaceholder.state = s;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return this.getCapability(cap);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
            return LazyOptional.of((NonNullSupplier)(cap == CAPABILITY_RECORD ? () -> this.container : null));
        }
    }

    public static class Storage
    implements Capability.IStorage<Container> {
        @Nullable
        public INBT writeNBT(Capability<Container> capability, Container instance, Direction side) {
            return null;
        }

        public void readNBT(Capability<Container> capability, Container instance, Direction side, INBT nbt) {
        }
    }

    public static class Container {
        RecordPlayer record;

        public RecordPlayer getRecord() {
            if (this.record == null) {
                this.record = new RecordPlayer();
            }
            return this.record;
        }

        public void setRecord(RecordPlayer r) {
            this.record = r;
        }
    }
}

