/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class TagStackIngredient {
    public static final IIngredientSerializer<Ingredient> SERIALIZER = new IIngredientSerializer<Ingredient>(){

        public void write(PacketBuffer buffer, Ingredient ingredient) {
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }

        public Ingredient parse(PacketBuffer buffer) {
            return Ingredient.func_209357_a(Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()));
        }

        public Ingredient parse(JsonObject json) {
            ResourceLocation tagID = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
            int count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
            ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(tagID);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + tagID + "'");
            }
            return Ingredient.func_209357_a(tag.func_230236_b_().stream().map(item -> new Ingredient.SingleItemList(new ItemStack((IItemProvider)item, count))));
        }
    };
}

