/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.jumbo_furnace;

import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.items.ItemStackHandler;

public class OutputItemHandler
extends ItemStackHandler {
    public static final String EXPERIENCE = "xp";
    public final JumboFurnaceCoreTileEntity te;
    public boolean forcingInserts = false;
    public final float[] storedExperience;

    public OutputItemHandler(JumboFurnaceCoreTileEntity te) {
        super(9);
        this.te = te;
        this.storedExperience = new float[9];
    }

    public void addExperience(int slot, float experience) {
        int n = slot;
        this.storedExperience[n] = this.storedExperience[n] + experience;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.forcingInserts;
    }

    public ItemStack insertCraftResult(int slot, ItemStack stack, boolean simulate) {
        this.forcingInserts = true;
        ItemStack result = this.insertItem(slot, stack, simulate);
        this.forcingInserts = false;
        return result;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.te.func_70296_d();
        this.te.onOutputInventoryChanged();
    }

    public float getAndConsumeExperience(int index) {
        float amount = this.storedExperience[index];
        this.storedExperience[index] = 0.0f;
        return amount;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT result = super.serializeNBT();
        ListNBT list = new ListNBT();
        for (float experience : this.storedExperience) {
            list.add((Object)FloatNBT.func_229689_a_((float)experience));
        }
        result.func_218657_a(EXPERIENCE, (INBT)list);
        return result;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        ListNBT list = nbt.func_150295_c(EXPERIENCE, 5);
        int listSize = list.size();
        int slotCount = this.storedExperience.length;
        int slotsToRead = Math.min(listSize, slotCount);
        for (int i = 0; i < slotsToRead; ++i) {
            this.storedExperience[i] = list.func_150308_e(i);
        }
    }
}

