/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.jumbo_furnace;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.JumboFurnaceObjects;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class MultiBlockHelper {
    public static final List<Pair<BlockPos, BlockState>> NO_SNAPSHOTS = ImmutableList.of();

    public static List<Pair<BlockPos, BlockState>> getJumboFurnaceStates(RegistryKey<World> key, IWorld world, BlockPos placePos, BlockState againstState, Entity entity) {
        return MultiBlockHelper.get3x3CubeAround(placePos).filter(pos -> MultiBlockHelper.canJumboFurnaceFormAt(world, pos, placePos)).map(pos -> MultiBlockHelper.getStatesForPlacementIfPermitted(key, world, pos, againstState, entity)).filter(list -> !list.isEmpty()).findFirst().orElse((List)ImmutableList.of());
    }

    public static boolean canJumboFurnaceFormAt(IWorld world, BlockPos corePos, BlockPos placePos) {
        return MultiBlockHelper.get3x3CubeAround(corePos).allMatch(pos -> pos.equals((Object)placePos) || JumboFurnace.JUMBOFURNACEABLE_TAG.func_230235_a_((Object)world.func_180495_p(pos).func_177230_c()));
    }

    public static boolean canJumboFurnacePlaceAt(IWorld world, BlockPos corePos, BlockItemUseContext useContext) {
        boolean noEntitiesInArea = world.func_217357_a(LivingEntity.class, new AxisAlignedBB(corePos.func_177982_a(-1, -1, -1), corePos.func_177982_a(2, 2, 2))).isEmpty();
        return noEntitiesInArea && MultiBlockHelper.get3x3CubeAround(corePos).allMatch(pos -> world.func_180495_p(pos).func_196953_a(useContext));
    }

    public static Stream<BlockPos> get3x3CubeAround(BlockPos pos) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1));
    }

    public static List<Pair<BlockPos, BlockState>> getStatesForPlacementIfPermitted(RegistryKey<World> key, IWorld world, BlockPos corePos, BlockState againstState, Entity placer) {
        List<Pair<BlockPos, BlockState>> pairs = JumboFurnaceObjects.BLOCK.getStatesForFurnace(world, corePos);
        return MultiBlockHelper.doesPlayerHavePermissionToMakeJumboFurnace(key, world, pairs, againstState, placer) ? pairs : NO_SNAPSHOTS;
    }

    public static boolean doesPlayerHavePermissionToMakeJumboFurnace(RegistryKey<World> key, IWorld world, List<Pair<BlockPos, BlockState>> pairs, BlockState placedAgainst, Entity entity) {
        List snapshots = pairs.stream().map(pair -> BlockSnapshot.create((RegistryKey)key, (IWorld)world, (BlockPos)((BlockPos)pair.getFirst()))).collect(Collectors.toList());
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(snapshots, placedAgainst, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }
}

