/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.jumbo_furnace;

import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.JumboFurnaceObjects;
import commoble.jumbofurnace.advancements.UpgradeJumboFurnaceTrigger;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreTileEntity;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceFuelSlot;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceOutputSlot;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceSyncData;
import commoble.jumbofurnace.jumbo_furnace.MultiprocessUpgradeHandler;
import commoble.jumbofurnace.jumbo_furnace.UninsertableItemStackHandler;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class JumboFurnaceContainer
extends Container {
    public static final ITextComponent TITLE = new TranslationTextComponent("container.jumbofurnace.jumbo_furnace");
    public static final int SLOT_SPACING = 18;
    public static final int INPUT_START_X = 8;
    public static final int INPUT_START_Y = 18;
    public static final int FUEL_START_X = 8;
    public static final int FUEL_START_Y = 90;
    public static final int OUTPUT_START_X = 116;
    public static final int OUTPUT_START_Y = 53;
    public static final int BACKPACK_START_X = 8;
    public static final int BACKPACK_START_Y = 158;
    public static final int HOTBAR_START_X = 8;
    public static final int HOTBAR_START_Y = 216;
    public static final int ORTHOFURNACE_SLOT_X = 134;
    public static final int ORTHOFURNACE_SLOT_Y = 117;
    public static final int SLOT_ROWS = 3;
    public static final int SLOT_COLUMNS = 3;
    public static final int BACKPACK_ROWS = 3;
    public static final int PLAYER_COLUMNS = 9;
    public static final int INPUT_SLOTS = 9;
    public static final int BACKPACK_SLOTS = 27;
    public static final int HOTBAR_SLOTS = 9;
    public static final int FIRST_INPUT_SLOT = 0;
    public static final int FIRST_FUEL_SLOT = 9;
    public static final int FIRST_OUTPUT_SLOT = 18;
    public static final int ORTHOFURNACE_SLOT = 27;
    public static final int FIRST_HOTBAR_SLOT = 28;
    public static final int FIRST_BACKPACK_SLOT = 37;
    public static final int FIRST_PLAYER_SLOT = 28;
    public static final int END_INPUT_SLOTS = 9;
    public static final int END_FUEL_SLOTS = 18;
    public static final int END_PLAYER_SLOTS = 64;
    private final IWorldPosCallable usabilityTest;
    private final IIntArray furnaceData;
    private final Optional<JumboFurnaceCoreTileEntity> serverFurnace;

    public static JumboFurnaceContainer getClientContainer(int id, PlayerInventory playerInventory) {
        return new JumboFurnaceContainer(id, playerInventory, BlockPos.field_177992_a, (IItemHandler)new ItemStackHandler(9), (IItemHandler)new ItemStackHandler(9), (IItemHandler)new UninsertableItemStackHandler(9), (IItemHandler)new ItemStackHandler(1), (IIntArray)new IntArray(4), Optional.empty());
    }

    public static IContainerProvider getServerContainerProvider(JumboFurnaceCoreTileEntity te, BlockPos activationPos) {
        return (id, playerInventory, serverPlayer) -> new JumboFurnaceContainer(id, playerInventory, activationPos, (IItemHandler)te.input, (IItemHandler)te.fuel, (IItemHandler)te.output, (IItemHandler)te.multiprocessUpgradeHandler, new JumboFurnaceSyncData(te), Optional.of(te));
    }

    protected JumboFurnaceContainer(int id, PlayerInventory playerInventory, BlockPos pos, IItemHandler inputs, IItemHandler fuel, IItemHandler outputs, IItemHandler multiprocessUpgrades, IIntArray furnaceData, Optional<JumboFurnaceCoreTileEntity> serverFurnace) {
        super(JumboFurnaceObjects.CONTAINER_TYPE, id);
        int index;
        int x;
        int column;
        int y;
        int row;
        PlayerEntity player = playerInventory.field_70458_d;
        this.usabilityTest = IWorldPosCallable.func_221488_a((World)player.field_70170_p, (BlockPos)pos);
        this.furnaceData = furnaceData;
        this.serverFurnace = serverFurnace;
        for (row = 0; row < 3; ++row) {
            y = 18 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 8 + 18 * column;
                index = row * 3 + column;
                this.func_75146_a((Slot)new SlotItemHandler(inputs, index, x, y));
            }
        }
        for (row = 0; row < 3; ++row) {
            y = 90 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 8 + 18 * column;
                index = row * 3 + column;
                this.func_75146_a((Slot)new JumboFurnaceFuelSlot(fuel, index, x, y));
            }
        }
        for (row = 0; row < 3; ++row) {
            y = 53 + 18 * row;
            for (column = 0; column < 3; ++column) {
                x = 116 + 18 * column;
                index = row * 3 + column;
                this.func_75146_a((Slot)new JumboFurnaceOutputSlot(player, outputs, index, x, y));
            }
        }
        this.func_75146_a((Slot)new MultiprocessUpgradeHandler.MultiprocessUpgradeSlotHandler(multiprocessUpgrades, 0, 134, 117));
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            int x2 = 8 + 18 * hotbarSlot;
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbarSlot, x2, 216));
        }
        for (row = 0; row < 3; ++row) {
            y = 158 + 18 * row;
            for (column = 0; column < 9; ++column) {
                x = 8 + 18 * column;
                index = row * 9 + column + 9;
                this.func_75146_a(new Slot((IInventory)playerInventory, index, x, y));
            }
        }
        this.func_216961_a(furnaceData);
    }

    public void func_75134_a(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            ItemStack finalUpgradeStack = this.func_75139_a(27).func_75211_c();
            UpgradeJumboFurnaceTrigger.INSTANCE.test((ServerPlayerEntity)player, finalUpgradeStack);
        }
        super.func_75134_a(player);
    }

    public boolean func_75145_c(PlayerEntity arg0) {
        return JumboFurnaceContainer.func_216963_a((IWorldPosCallable)this.usabilityTest, (PlayerEntity)arg0, (Block)JumboFurnaceObjects.BLOCK);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            slotStackCopy = stackInSlot.func_77946_l();
            if (index < 28) {
                if (!this.func_75135_a(stackInSlot, 28, 64, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (JumboFurnace.MULTIPROCESSING_UPGRADE_TAG.func_230235_a_((Object)stackInSlot.func_77973_b())) {
                    if (this.func_75135_a(stackInSlot, 27, 28, false)) {
                        this.serverFurnace.ifPresent(JumboFurnaceCoreTileEntity::markInputInventoryChanged);
                    } else {
                        return ItemStack.field_190927_a;
                    }
                }
                if (ForgeHooks.getBurnTime((ItemStack)stackInSlot) > 0) {
                    if (this.func_75135_a(stackInSlot, 9, 18, false)) {
                        this.serverFurnace.ifPresent(JumboFurnaceCoreTileEntity::markFuelInventoryChanged);
                    } else {
                        return ItemStack.field_190927_a;
                    }
                }
                if (this.func_75135_a(stackInSlot, 0, 9, false)) {
                    this.serverFurnace.ifPresent(JumboFurnaceCoreTileEntity::markInputInventoryChanged);
                } else {
                    return ItemStack.field_190927_a;
                }
            }
            if (stackInSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return slotStackCopy;
    }

    public int getBurnTimeRemaining() {
        return this.furnaceData.func_221476_a(0);
    }

    public int getItemBurnedValue() {
        return this.furnaceData.func_221476_a(1);
    }

    public int getCookProgress() {
        return this.furnaceData.func_221476_a(2);
    }

    public int getCookProgressionScaled() {
        int cookProgress = this.getCookProgress();
        int cookTimeForRecipe = JumboFurnace.SERVER_CONFIG.jumboFurnaceCookTime.get();
        return cookTimeForRecipe != 0 && cookProgress != 0 ? cookProgress * 24 / cookTimeForRecipe : 0;
    }

    public int getBurnLeftScaled() {
        int totalBurnTime = this.getItemBurnedValue();
        if (totalBurnTime == 0) {
            totalBurnTime = 200;
        }
        return this.getBurnTimeRemaining() * 13 / totalBurnTime;
    }

    public boolean isBurning() {
        return this.getBurnTimeRemaining() > 0;
    }
}

