/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace;

import com.mojang.datafixers.util.Pair;
import commoble.jumbofurnace.JumboFurnaceObjects;
import commoble.jumbofurnace.OrthodimensionalHyperfurnaceItem;
import commoble.jumbofurnace.advancements.AssembleJumboFurnaceTrigger;
import commoble.jumbofurnace.advancements.UpgradeJumboFurnaceTrigger;
import commoble.jumbofurnace.client.ClientEvents;
import commoble.jumbofurnace.client.OrthodimensionalHyperfurnaceRenderer;
import commoble.jumbofurnace.config.ConfigHelper;
import commoble.jumbofurnace.config.ServerConfig;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceBlock;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceContainer;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceCoreTileEntity;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceExteriorTileEntity;
import commoble.jumbofurnace.jumbo_furnace.JumboFurnaceItem;
import commoble.jumbofurnace.jumbo_furnace.MultiBlockHelper;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipe;
import commoble.jumbofurnace.recipes.JumboFurnaceRecipeSerializer;
import commoble.jumbofurnace.recipes.RecipeSorter;
import commoble.jumbofurnace.recipes.TagStackIngredient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="jumbofurnace")
public class JumboFurnace {
    public static final String MODID = "jumbofurnace";
    public static final IRecipeType<JumboFurnaceRecipe> JUMBO_SMELTING_RECIPE_TYPE = IRecipeType.func_222147_a((String)"jumbofurnace:jumbo_smelting");
    public static final ITag<Block> JUMBOFURNACEABLE_TAG = BlockTags.func_199894_a((String)"jumbofurnace:jumbofurnaceable");
    public static final ITag<Item> MULTIPROCESSING_UPGRADE_TAG = ItemTags.func_199901_a((String)"jumbofurnace:multiprocessing_upgrade");
    public static ServerConfig SERVER_CONFIG;

    public JumboFurnace() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        SERVER_CONFIG = ConfigHelper.register(ModConfig.Type.SERVER, ServerConfig::new);
        this.addModListeners(modBus);
        this.addForgeListeners(forgeBus);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.addClientListeners(modBus, forgeBus);
        }
    }

    private void addModListeners(IEventBus modBus) {
        DeferredRegister blocks = this.makeDeferredRegister(modBus, ForgeRegistries.BLOCKS);
        DeferredRegister items = this.makeDeferredRegister(modBus, ForgeRegistries.ITEMS);
        DeferredRegister tileEntities = this.makeDeferredRegister(modBus, ForgeRegistries.TILE_ENTITIES);
        DeferredRegister containers = this.makeDeferredRegister(modBus, ForgeRegistries.CONTAINERS);
        DeferredRegister recipeSerializers = this.makeDeferredRegister(modBus, ForgeRegistries.RECIPE_SERIALIZERS);
        blocks.register("jumbo_furnace", () -> new JumboFurnaceBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150460_al)));
        items.register("jumbo_furnace", () -> new JumboFurnaceItem(new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
        items.register("orthodimensional_hyperfurnace", () -> new OrthodimensionalHyperfurnaceItem(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).setISTER(() -> OrthodimensionalHyperfurnaceRenderer::new)));
        items.register("jumbo_furnace_jei", () -> new Item(new Item.Properties()){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
                tooltip.add((ITextComponent)new TranslationTextComponent("jumbofurnace.jumbo_furnace_info_tooltip"));
            }
        });
        tileEntities.register("jumbo_furnace_core", () -> TileEntityType.Builder.func_223042_a(JumboFurnaceCoreTileEntity::new, (Block[])new Block[]{JumboFurnaceObjects.BLOCK}).func_206865_a(null));
        tileEntities.register("jumbo_furnace_exterior", () -> TileEntityType.Builder.func_223042_a(JumboFurnaceExteriorTileEntity::new, (Block[])new Block[]{JumboFurnaceObjects.BLOCK}).func_206865_a(null));
        containers.register("jumbo_furnace", () -> new ContainerType(JumboFurnaceContainer::getClientContainer));
        recipeSerializers.register("jumbo_smelting", () -> new JumboFurnaceRecipeSerializer(JUMBO_SMELTING_RECIPE_TYPE));
        modBus.addGenericListener(IRecipeSerializer.class, this::onRegisterRecipeStuff);
        modBus.addListener(this::onCommonSetup);
    }

    private <T extends IForgeRegistryEntry<T>> DeferredRegister<T> makeDeferredRegister(IEventBus modBus, IForgeRegistry<T> registry) {
        DeferredRegister register = DeferredRegister.create(registry, (String)MODID);
        register.register(modBus);
        return register;
    }

    private void addForgeListeners(IEventBus forgeBus) {
        forgeBus.addListener(this::onAddServerReloadListeners);
        forgeBus.addListener(this::onEntityPlaceBlock);
        forgeBus.addListener(EventPriority.LOW, this::onRightClickBlockLow);
    }

    private void onAddServerReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)RecipeSorter.INSTANCE);
    }

    private void onEntityPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        block10: {
            Block block = event.getPlacedBlock().func_177230_c();
            IWorld world = event.getWorld();
            if (event instanceof BlockEvent.EntityMultiPlaceEvent || !JUMBOFURNACEABLE_TAG.func_230235_a_((Object)block) || !(world instanceof World)) break block10;
            BlockPos pos = event.getPos();
            BlockState againstState = event.getPlacedAgainst();
            Entity entity = event.getEntity();
            ArrayList stacks = new ArrayList();
            List<Pair<BlockPos, BlockState>> pairs = MultiBlockHelper.getJumboFurnaceStates((RegistryKey<World>)((World)world).func_234923_W_(), world, pos, againstState, entity);
            if (pairs.size() > 0) {
                for (Pair<BlockPos, BlockState> pair : pairs) {
                    BlockPos newPos = (BlockPos)pair.getFirst();
                    BlockState newState = (BlockState)pair.getSecond();
                    TileEntity te = world.func_175625_s(newPos);
                    if (te != null) {
                        for (Direction dir : Direction.values()) {
                            te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).ifPresent(handler -> JumboFurnace.addItemsToList(stacks, handler));
                        }
                        te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> JumboFurnace.addItemsToList(stacks, handler));
                    }
                    world.func_180501_a(newPos, newState, 3);
                }
                if (entity instanceof ServerPlayerEntity) {
                    AssembleJumboFurnaceTrigger.INSTANCE.trigger((ServerPlayerEntity)entity);
                }
            }
            if (!stacks.isEmpty()) {
                if (entity instanceof PlayerEntity) {
                    for (ItemStack stack : stacks) {
                        ((PlayerEntity)entity).func_191521_c(stack);
                    }
                } else {
                    for (ItemStack stack : stacks) {
                        entity.func_199701_a_(stack);
                    }
                }
            }
        }
    }

    private void onRightClickBlockLow(PlayerInteractEvent.RightClickBlock event) {
        if (JumboFurnace.SERVER_CONFIG.allowShearing.get().booleanValue() && event.getUseItem() != Event.Result.DENY && event.getUseBlock() != Event.Result.DENY) {
            BlockPos pos;
            World world;
            BlockState state;
            PlayerEntity player = event.getPlayer();
            ItemStack stack = event.getItemStack();
            if (player.func_226563_dT_() && Tags.Items.SHEARS.func_230235_a_((Object)stack.func_77973_b()) && (state = (world = event.getWorld()).func_180495_p(pos = event.getPos())).func_177230_c() == JumboFurnaceObjects.BLOCK) {
                if (!world.field_72995_K) {
                    BlockPos corePos = JumboFurnaceBlock.getCorePos(state, pos);
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)JumboFurnaceObjects.ITEM));
                    Hand hand = event.getHand();
                    stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(hand));
                    MultiBlockHelper.get3x3CubeAround(corePos).forEach(componentPos -> world.func_217377_a(componentPos, true));
                }
                world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187763_eJ, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(this::afterCommonSetup);
    }

    private void afterCommonSetup() {
        CriteriaTriggers.func_192118_a((ICriterionTrigger)AssembleJumboFurnaceTrigger.INSTANCE);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)UpgradeJumboFurnaceTrigger.INSTANCE);
    }

    private void onRegisterRecipeStuff(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((ResourceLocation)new ResourceLocation("jumbofurnace:tag_stack"), TagStackIngredient.SERIALIZER);
    }

    private static void addItemsToList(List<ItemStack> stacks, IItemHandler handler) {
        int slots = handler.getSlots();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = handler.extractItem(slot, 64, false);
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
    }
}

