/*
 * Decompiled with CFR 0.152.
 */
package commoble.jumbofurnace.recipes;

import commoble.jumbofurnace.JumboFurnace;
import commoble.jumbofurnace.JumboFurnaceObjects;
import commoble.jumbofurnace.recipes.ClaimableRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class JumboFurnaceRecipe
implements IRecipe<ClaimableRecipeWrapper> {
    public final IRecipeType<?> type;
    public final ResourceLocation id;
    public final String group;
    public final NonNullList<Ingredient> ingredients;
    public final ItemStack result;
    public final float experience;

    public JumboFurnaceRecipe(FurnaceRecipe baseRecipe) {
        this(JumboFurnace.JUMBO_SMELTING_RECIPE_TYPE, baseRecipe.func_199560_c(), baseRecipe.func_193358_e(), (NonNullList<Ingredient>)baseRecipe.func_192400_c(), baseRecipe.func_77571_b().func_77946_l(), baseRecipe.func_222138_b());
    }

    public JumboFurnaceRecipe(IRecipeType<?> type, ResourceLocation id, String group, NonNullList<Ingredient> ingredients, ItemStack result, float experience) {
        this.type = type;
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.result = result;
        this.experience = experience;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public boolean matches(ClaimableRecipeWrapper inv, World worldIn) {
        IItemHandler unusedInputs = inv.getUnusedInputs();
        NonNullList<Ingredient> ingredients = this.func_192400_c();
        for (Ingredient ingredient : ingredients) {
            int amountOfIngredient = ingredient.func_193365_a()[0].func_190916_E();
            int slots = unusedInputs.getSlots();
            for (int slot = 0; slot < slots && amountOfIngredient > 0; ++slot) {
                ItemStack stackInSlot = unusedInputs.getStackInSlot(slot);
                if (!ingredient.test(stackInSlot) || stackInSlot.func_190916_E() < amountOfIngredient) continue;
                ItemStack usedStack = unusedInputs.extractItem(slot, amountOfIngredient, false);
                amountOfIngredient -= usedStack.func_190916_E();
            }
            if (amountOfIngredient <= 0) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCraftingResult(ClaimableRecipeWrapper inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return JumboFurnaceObjects.RECIPE_SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    public int getSpecificity() {
        int specificity = (int)(this.experience * 10.0f);
        int totalItems = ForgeRegistries.ITEMS.getKeys().size();
        for (Ingredient ingredient : this.ingredients) {
            ItemStack[] matchingStacks = ingredient.func_193365_a();
            if (matchingStacks.length < 1) continue;
            int matchingItems = Math.min(totalItems, matchingStacks.length);
            double matchFactor = (double)(totalItems - matchingItems) / (double)(totalItems - 1);
            int ingredientWeight = (int)(100.0 * (double)matchingStacks[0].func_190916_E() * matchFactor);
            specificity += ingredientWeight;
        }
        return specificity;
    }

    public NonNullList<ItemStack> getRemainingItems(ClaimableRecipeWrapper inv) {
        IItemHandler items = inv.getItemsBeingSmelted();
        int slots = items.getSlots();
        NonNullList containerItems = NonNullList.func_191197_a((int)items.getSlots(), (Object)ItemStack.field_190927_a);
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stackInSlot = items.getStackInSlot(slot);
            if (!stackInSlot.hasContainerItem()) continue;
            containerItems.set(slot, (Object)stackInSlot.getContainerItem());
        }
        return containerItems;
    }
}

