/*
 * Decompiled with CFR 0.152.
 */
package com.snowshock35.jeiintegration;

import com.snowshock35.jeiintegration.JEIIntegration;
import com.snowshock35.jeiintegration.config.Config;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class TooltipEventHandler {
    private Config.Client config = Config.CLIENT;

    private static boolean isDebugMode() {
        return Minecraft.func_71410_x().field_71474_y.field_82882_x;
    }

    private static boolean isShiftKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
    }

    private void registerTooltip(ItemTooltipEvent e, ITextComponent tooltip, String configOption) {
        boolean isEnabled = false;
        if (Objects.equals(configOption, "enabled")) {
            isEnabled = true;
        } else if (Objects.equals(configOption, "onShift") && TooltipEventHandler.isShiftKeyDown()) {
            isEnabled = true;
        } else if (Objects.equals(configOption, "onDebug") && TooltipEventHandler.isDebugMode()) {
            isEnabled = true;
        } else if (Objects.equals(configOption, "onShiftAndDebug") && TooltipEventHandler.isShiftKeyDown() && TooltipEventHandler.isDebugMode()) {
            isEnabled = true;
        }
        if (isEnabled) {
            e.getToolTip().add(tooltip);
        }
    }

    private void registerTooltips(ItemTooltipEvent e, Collection<ITextComponent> tooltips, String configValue) {
        for (ITextComponent tooltip : tooltips) {
            this.registerTooltip(e, tooltip, configValue);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        CompoundNBT nbtData;
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        ItemStack itemStack = e.getItemStack();
        Item item = itemStack.func_77973_b();
        if (e.getItemStack().func_190926_b()) {
            return;
        }
        int burnTime = 0;
        try {
            burnTime = ForgeHooks.getBurnTime((ItemStack)itemStack);
        }
        catch (Exception ex) {
            JEIIntegration.logger.log(Level.WARN, "):\n\nSomething went wrong!");
        }
        if (burnTime > 0) {
            IFormattableTextComponent burnTooltip = new TranslationTextComponent("tooltip.jeiintegration.burnTime").func_230529_a_((ITextComponent)new StringTextComponent(" " + decimalFormat.format(burnTime) + " ")).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.jeiintegration.burnTime.suffix")).func_240699_a_(TextFormatting.DARK_GRAY);
            this.registerTooltip(e, (ITextComponent)burnTooltip, (String)this.config.burnTimeTooltipMode.get());
        }
        int maxDamage = itemStack.func_77958_k();
        int currentDamage = maxDamage - itemStack.func_77952_i();
        if (maxDamage > 0) {
            IFormattableTextComponent durabilityTooltip = new TranslationTextComponent("tooltip.jeiintegration.durability").func_230529_a_((ITextComponent)new StringTextComponent(" " + currentDamage + "/" + maxDamage)).func_240699_a_(TextFormatting.DARK_GRAY);
            this.registerTooltip(e, (ITextComponent)durabilityTooltip, (String)this.config.durabilityTooltipMode.get());
        }
        if (item.func_219971_r()) {
            int healVal = Objects.requireNonNull(item.func_219967_s()).func_221466_a();
            float satVal = (float)healVal * (item.func_219967_s().func_221469_b() * 2.0f);
            IFormattableTextComponent foodTooltip = new TranslationTextComponent("tooltip.jeiintegration.hunger").func_230529_a_((ITextComponent)new StringTextComponent(" " + healVal + " ")).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.jeiintegration.saturation")).func_230529_a_((ITextComponent)new StringTextComponent(" " + decimalFormat.format(satVal))).func_240699_a_(TextFormatting.DARK_GRAY);
            this.registerTooltip(e, (ITextComponent)foodTooltip, (String)this.config.foodTooltipMode.get());
        }
        if ((nbtData = item.getShareTag(itemStack)) != null) {
            IFormattableTextComponent nbtTooltip = new TranslationTextComponent("tooltip.jeiintegration.nbtTagData").func_230529_a_((ITextComponent)new StringTextComponent(" " + nbtData)).func_240699_a_(TextFormatting.DARK_GRAY);
            this.registerTooltip(e, (ITextComponent)nbtTooltip, (String)this.config.nbtTooltipMode.get());
        }
        IFormattableTextComponent registryTooltip = new TranslationTextComponent("tooltip.jeiintegration.registryName").func_230529_a_((ITextComponent)new StringTextComponent(" " + item.getRegistryName())).func_240699_a_(TextFormatting.DARK_GRAY);
        this.registerTooltip(e, (ITextComponent)registryTooltip, (String)this.config.registryNameTooltipMode.get());
        int stackSize = e.getItemStack().func_77976_d();
        if (stackSize > 0) {
            IFormattableTextComponent stackSizeTooltip = new TranslationTextComponent("tooltip.jeiintegration.maxStackSize").func_230529_a_((ITextComponent)new StringTextComponent(" " + itemStack.func_77976_d())).func_240699_a_(TextFormatting.DARK_GRAY);
            this.registerTooltip(e, (ITextComponent)stackSizeTooltip, (String)this.config.maxStackSizeTooltipMode.get());
        }
        if (item.getTags().size() > 0) {
            IFormattableTextComponent tagsTooltip = new TranslationTextComponent("tooltip.jeiintegration.tags").func_240699_a_(TextFormatting.DARK_GRAY);
            HashSet<ITextComponent> tags = new HashSet<ITextComponent>();
            for (ResourceLocation tag : item.getTags()) {
                tags.add((ITextComponent)new StringTextComponent("    " + tag).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            this.registerTooltip(e, (ITextComponent)tagsTooltip, (String)this.config.tagsTooltipMode.get());
            this.registerTooltips(e, tags, (String)this.config.tagsTooltipMode.get());
        }
        IFormattableTextComponent translationKeyTooltip = new TranslationTextComponent("tooltip.jeiintegration.translationKey").func_230529_a_((ITextComponent)new StringTextComponent(" " + itemStack.func_77977_a())).func_240699_a_(TextFormatting.DARK_GRAY);
        this.registerTooltip(e, (ITextComponent)translationKeyTooltip, (String)this.config.translationKeyTooltipMode.get());
    }
}

