/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.List;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;

public class CraftingGridHelper
implements ICraftingGridHelper {
    private final int craftInputSlot1;

    public CraftingGridHelper(int craftInputSlot1) {
        this.craftInputSlot1 = craftInputSlot1;
    }

    @Override
    public <T> void setInputs(IGuiIngredientGroup<T> ingredientGroup, List<List<T>> inputs) {
        int width;
        int height;
        if (inputs.size() > 4) {
            height = 3;
            width = 3;
        } else if (inputs.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputs(ingredientGroup, inputs, width, height);
    }

    @Override
    public <T> void setInputs(IGuiIngredientGroup<T> ingredientGroup, List<List<T>> inputs, int width, int height) {
        for (int i = 0; i < inputs.size(); ++i) {
            List<T> recipeItem = inputs.get(i);
            int index = this.getCraftingIndex(i, width, height);
            this.setInput(ingredientGroup, index, recipeItem);
        }
    }

    private <T> void setInput(IGuiIngredientGroup<T> guiIngredients, int inputIndex, List<T> input) {
        guiIngredients.set(this.craftInputSlot1 + inputIndex, input);
    }

    private int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }
}

