/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientType;
import net.mehvahdjukaar.jeed.jei.JeiStuff;
import net.mehvahdjukaar.jeed.jei.plugins.CompatHandler;
import net.mehvahdjukaar.jeed.recipes.EffectProviderRecipe;
import net.mehvahdjukaar.jeed.recipes.PotionProviderRecipe;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectInfoRecipe {
    private static final Lazy<Map<Effect, List<ItemStack>>> EFFECT_PROVIDERS_CACHE = Lazy.of(EffectInfoRecipe::buildEffectProviderCache);
    private static final int lineSpacing = 2;
    private final List<ITextProperties> description;
    private final EffectInstance effect;
    private final IIngredientType<EffectInstance> effectIngredientType;
    private final List<ItemStack> inputItems;

    private EffectInfoRecipe(EffectInstance effectInstance, IIngredientType<EffectInstance> ingredientType, List<ITextProperties> description) {
        this.description = description;
        this.effect = effectInstance;
        this.effectIngredientType = ingredientType;
        this.inputItems = EffectInfoRecipe.getEffectProviders(effectInstance.func_188419_a());
    }

    private static Map<Effect, List<ItemStack>> buildEffectProviderCache() {
        HashMap<Effect, List<ItemStack>> effectProvidingItems = new HashMap<Effect, List<ItemStack>>();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            List<EffectProviderRecipe> recipes = EffectInfoRecipe.getRecipesOfType((World)world, r -> r instanceof EffectProviderRecipe ? (EffectProviderRecipe)r : null);
            for (EffectProviderRecipe p : recipes) {
                p.getEffects().stream().forEach(e -> effectProvidingItems.computeIfAbsent((Effect)e, i -> new ItemStackList()).addAll(p.getProviders()));
            }
            List<PotionProviderRecipe> potionRecipes = EffectInfoRecipe.getRecipesOfType((World)world, r -> r instanceof PotionProviderRecipe ? (PotionProviderRecipe)r : null);
            for (PotionProviderRecipe p : potionRecipes) {
                for (ItemStack stack : p.getProviders()) {
                    Collection<Object> acceptablePotions = p.getPotions();
                    if (acceptablePotions.isEmpty()) {
                        acceptablePotions = ForgeRegistries.POTION_TYPES.getValues();
                    }
                    for (Potion potion : acceptablePotions) {
                        ItemStack copy = stack.func_77946_l();
                        PotionUtils.func_185188_a((ItemStack)copy, (Potion)potion);
                        for (EffectInstance effect : potion.func_185170_a()) {
                            effectProvidingItems.computeIfAbsent(effect.func_188419_a(), i -> new ItemStackList()).add(copy);
                        }
                    }
                }
            }
            for (Block b : ForgeRegistries.BLOCKS) {
                if (!(b instanceof FlowerBlock)) continue;
                ItemStack stew = new ItemStack((IItemProvider)Items.field_222115_pz);
                FlowerBlock flowerblock = (FlowerBlock)b;
                Effect effect = flowerblock.func_220094_d();
                SuspiciousStewItem.func_220037_a((ItemStack)stew, (Effect)effect, (int)200);
                effectProvidingItems.computeIfAbsent(effect, i -> new ItemStackList()).add(stew);
            }
            for (Item i2 : ForgeRegistries.ITEMS) {
                Food food = i2.func_219967_s();
                if (food == null) continue;
                ItemStack foodItem = new ItemStack((IItemProvider)i2);
                for (Pair pair : food.func_221464_f()) {
                    effectProvidingItems.computeIfAbsent(((EffectInstance)pair.getFirst()).func_188419_a(), s -> new ItemStackList()).add(foodItem);
                }
            }
            for (Effect[] array : BeaconTileEntity.field_146009_a) {
                for (Effect e2 : array) {
                    effectProvidingItems.computeIfAbsent(e2, s -> new ItemStackList()).add(Items.field_221749_dK.func_190903_i());
                }
            }
        }
        return effectProvidingItems;
    }

    private static <T> List<T> getRecipesOfType(World world, Function<IRecipe<?>, T> function) {
        return world.func_199532_z().func_199510_b().stream().map(function).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ItemStack> getInputItems() {
        if (!CompatHandler.REI) {
            return JeiStuff.getInputItems(this.inputItems);
        }
        return this.inputItems.stream().filter(s -> !s.func_190926_b()).collect(Collectors.toList());
    }

    private static NonNullList<ItemStack> getEffectProviders(Effect effect) {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll((Collection)((Map)EFFECT_PROVIDERS_CACHE.get()).getOrDefault(effect, new ItemStackList()));
        return list;
    }

    public static List<EffectInfoRecipe> create(EffectInstance ingredient, IIngredientType<EffectInstance> ingredientType, String descriptionKey) {
        TranslationTextComponent text = new TranslationTextComponent(descriptionKey);
        if (text.getString().equals(descriptionKey)) {
            text = new TranslationTextComponent("jeed.description.missing");
        }
        return EffectInfoRecipe.create(ingredient, ingredientType, (ITextComponent)text);
    }

    public static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    public static List<EffectInfoRecipe> create(EffectInstance ingredient, IIngredientType<EffectInstance> ingredientType, ITextComponent descriptionComponent) {
        ArrayList<EffectInfoRecipe> recipes = new ArrayList<EffectInfoRecipe>();
        List<ITextProperties> descriptionLines = EffectInfoRecipe.expandNewlines(descriptionComponent);
        descriptionLines = EffectInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.getClass();
        int maxLinesPerPage = 45 / (9 + 2);
        int pageCount = EffectInfoRecipe.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<ITextProperties> description = descriptionLines.subList(startLine, endLine);
            EffectInfoRecipe recipe = new EffectInfoRecipe(ingredient, ingredientType, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static List<ITextProperties> expandNewlines(ITextComponent ... descriptionComponents) {
        ArrayList<ITextProperties> descriptionLinesExpanded = new ArrayList<ITextProperties>();
        for (ITextComponent descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.func_230439_a_((ITextProperties.IStyledTextAcceptor)newLineTextAcceptor, Style.field_240709_b_);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }

    private static List<ITextProperties> wrapDescriptionLines(List<ITextProperties> descriptionLines) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ArrayList<ITextProperties> descriptionLinesWrapped = new ArrayList<ITextProperties>();
        for (ITextProperties descriptionLine : descriptionLines) {
            List textLines = minecraft.field_71466_p.func_238420_b_().func_238362_b_(descriptionLine, 160, Style.field_240709_b_);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    public List<ITextProperties> getDescription() {
        return this.description;
    }

    public IIngredientType<EffectInstance> getEffectIngredientType() {
        return this.effectIngredientType;
    }

    public EffectInstance getEffect() {
        return this.effect;
    }

    private static class ItemStackList
    extends ArrayList<ItemStack> {
        public ItemStackList() {
        }

        public ItemStackList(Effect ignored) {
        }

        @Override
        public boolean add(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            for (ItemStack thisStack : this) {
                if (!ItemStack.func_77989_b((ItemStack)thisStack, (ItemStack)stack)) continue;
                return false;
            }
            return super.add(stack);
        }
    }

    private static class ExpandNewLineTextAcceptor
    implements ITextProperties.IStyledTextAcceptor<Void> {
        private final List<ITextProperties> lines = new ArrayList<ITextProperties>();
        @Nullable
        private IFormattableTextComponent lastComponent;

        private ExpandNewLineTextAcceptor() {
        }

        public Optional<Void> accept(Style style, String line) {
            String[] descriptionLineExpanded = line.split("\\\\n");
            for (int i = 0; i < descriptionLineExpanded.length; ++i) {
                String s = descriptionLineExpanded[i];
                if (s.isEmpty()) {
                    if (i == 0 && this.lastComponent != null) {
                        this.lines.add((ITextProperties)this.lastComponent);
                        this.lastComponent = null;
                        continue;
                    }
                    this.lines.add((ITextProperties)StringTextComponent.field_240750_d_);
                    continue;
                }
                StringTextComponent textComponent = new StringTextComponent(s);
                textComponent.func_230530_a_(style);
                if (this.lastComponent != null) {
                    if (i == 0) {
                        if (!this.lastComponent.func_150256_b().func_150229_g() && !this.lastComponent.func_150256_b().equals((Object)style)) {
                            this.lastComponent = new StringTextComponent("").func_230529_a_((ITextComponent)this.lastComponent);
                        }
                        this.lastComponent.func_230529_a_((ITextComponent)textComponent);
                        continue;
                    }
                    this.lines.add((ITextProperties)this.lastComponent);
                    this.lastComponent = null;
                }
                if (i == descriptionLineExpanded.length - 1) {
                    this.lastComponent = textComponent;
                    continue;
                }
                this.lines.add((ITextProperties)textComponent);
            }
            return Optional.empty();
        }

        public void addLinesTo(List<ITextProperties> descriptionLinesExpanded) {
            descriptionLinesExpanded.addAll(this.lines);
            if (this.lastComponent != null) {
                descriptionLinesExpanded.add((ITextProperties)this.lastComponent);
            }
        }
    }
}

