/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonHelper {
    public static NonNullList<ItemStack> readItemStackList(JsonArray resultArray) {
        NonNullList results = NonNullList.func_191196_a();
        for (JsonElement result : resultArray) {
            results.add((Object)CraftingHelper.getItemStack((JsonObject)result.getAsJsonObject(), (boolean)true));
        }
        return results;
    }

    public static List<Potion> readPotionList(JsonArray resultArray) {
        ArrayList<Potion> results = new ArrayList<Potion>();
        for (JsonElement result : resultArray) {
            String id = JSONUtils.func_151200_h((JsonObject)result.getAsJsonObject(), (String)"id");
            results.add(JsonHelper.getPotion(new ResourceLocation(id)));
        }
        return results;
    }

    public static Potion getPotion(ResourceLocation potionName) {
        Potion potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(potionName);
        if (potion == null) {
            throw new JsonSyntaxException("Unknown potion '" + potionName + "'");
        }
        return potion;
    }

    public static Effect getEffect(ResourceLocation effectName) {
        Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(effectName);
        if (effect == null) {
            throw new JsonSyntaxException("Unknown effect '" + effectName + "'");
        }
        return effect;
    }
}

