/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.item;

import com.blakebr0.cucumber.energy.EnergyCapabilityProvider;
import com.blakebr0.cucumber.energy.ItemEnergyStorage;
import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.item.BaseArmorItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.ironjetpacks.client.model.JetpackModel;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.handler.InputHandler;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class JetpackItem
extends BaseArmorItem
implements IColored,
IDyeableArmorItem,
IEnableable {
    private final Jetpack jetpack;
    private BipedModel<?> model;

    public JetpackItem(Jetpack jetpack, Function<Item.Properties, Item.Properties> properties) {
        super(JetpackUtils.makeArmorMaterial(jetpack), EquipmentSlotType.CHEST, properties.compose(p -> p.func_200915_b(0).func_208103_a(jetpack.rarity)));
        this.jetpack = jetpack;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return Localizable.of((String)"item.ironjetpacks.jetpack").args(new Object[]{this.jetpack.displayName}).build();
    }

    public String func_77667_c(ItemStack stack) {
        return Localizable.of((String)"item.ironjetpacks.jetpack").args(new Object[]{this.jetpack.displayName}).buildString();
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        Item item = chest.func_77973_b();
        if (!chest.func_190926_b() && item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (JetpackUtils.isEngineOn(chest)) {
                boolean hover = JetpackUtils.isHovering(chest);
                if (InputHandler.isHoldingUp(player) || hover && !player.func_233570_aj_()) {
                    Jetpack info = jetpack.getJetpack();
                    double motionY = player.func_213322_ci().func_82617_b();
                    double hoverSpeed = InputHandler.isHoldingDown(player) ? info.speedHover : info.speedHoverSlow;
                    double currentAccel = info.accelVert * (motionY < 0.3 ? 2.5 : 1.0);
                    double currentSpeedVertical = info.speedVert * (player.func_70090_H() ? 0.4 : 1.0);
                    double usage = player.func_70051_ag() || InputHandler.isHoldingSprint(player) ? (double)info.usage * info.sprintFuel : (double)info.usage;
                    boolean creative = info.creative;
                    IEnergyStorage energy = JetpackUtils.getEnergyStorage(chest);
                    if (!player.func_184812_l_() && !creative) {
                        energy.extractEnergy((int)usage, false);
                    }
                    if (energy.getEnergyStored() > 0 || player.func_184812_l_() || creative) {
                        double verticalSprintMulti;
                        double throttle = JetpackUtils.getThrottle(stack);
                        double d = verticalSprintMulti = motionY >= 0.0 && InputHandler.isHoldingSprint(player) ? info.sprintSpeedVert : 1.0;
                        if (InputHandler.isHoldingUp(player)) {
                            if (!hover) {
                                JetpackItem.fly(player, Math.min(motionY + currentAccel, currentSpeedVertical) * throttle * verticalSprintMulti);
                            } else if (InputHandler.isHoldingDown(player)) {
                                JetpackItem.fly(player, Math.min(motionY + currentAccel, -info.speedHoverSlow) * throttle);
                            } else {
                                JetpackItem.fly(player, Math.min(motionY + currentAccel, info.speedHover) * throttle * verticalSprintMulti);
                            }
                        } else {
                            JetpackItem.fly(player, Math.min(motionY + currentAccel, -hoverSpeed) * throttle);
                        }
                        double speedSideways = (player.func_213453_ef() ? info.speedSide * 0.5 : info.speedSide) * throttle;
                        double speedForward = (player.func_70051_ag() ? speedSideways * info.sprintSpeed : speedSideways) * throttle;
                        if (InputHandler.isHoldingForwards(player)) {
                            player.func_213309_a(1.0f, new Vector3d(0.0, 0.0, speedForward));
                        }
                        if (InputHandler.isHoldingBackwards(player)) {
                            player.func_213309_a(1.0f, new Vector3d(0.0, 0.0, -speedSideways * (double)0.8f));
                        }
                        if (InputHandler.isHoldingLeft(player)) {
                            player.func_213309_a(1.0f, new Vector3d(speedSideways, 0.0, 0.0));
                        }
                        if (InputHandler.isHoldingRight(player)) {
                            player.func_213309_a(1.0f, new Vector3d(-speedSideways, 0.0, 0.0));
                        }
                        if (!world.func_201670_d()) {
                            player.field_70143_R = 0.0f;
                            if (player instanceof ServerPlayerEntity) {
                                ((ServerPlayerEntity)player).field_71135_a.field_147365_f = 0;
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return (Boolean)ModConfigs.ENCHANTABLE_JETPACKS.get() != false && this.jetpack.enchantablilty > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return (Boolean)ModConfigs.ENCHANTABLE_JETPACKS.get() != false && this.jetpack.enchantablilty > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
        double stored = energy.getMaxEnergyStored() - energy.getEnergyStored();
        return stored / (double)energy.getMaxEnergyStored();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.jetpack.creative;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (!this.jetpack.creative) {
            IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
            tooltip.add((ITextComponent)new StringTextComponent(Utils.format((Object)energy.getEnergyStored()) + " / " + Utils.format((Object)energy.getMaxEnergyStored()) + " FE").func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)ModTooltips.INFINITE.build().func_240702_b_(" FE"));
        }
        IFormattableTextComponent tier = ModTooltips.TIER.color(this.jetpack.rarity.field_77937_e).args(new Object[]{this.jetpack.creative ? "C" : Integer.valueOf(this.jetpack.tier)}).build();
        IFormattableTextComponent engine = ModTooltips.ENGINE.color(JetpackUtils.isEngineOn(stack) ? TextFormatting.GREEN : TextFormatting.RED).build();
        IFormattableTextComponent hover = ModTooltips.HOVER.color(JetpackUtils.isHovering(stack) ? TextFormatting.GREEN : TextFormatting.RED).build();
        tooltip.add((ITextComponent)ModTooltips.STATE_TOOLTIP_LAYOUT.args(new Object[]{tier, engine, hover}).build());
        StringTextComponent throttle = new StringTextComponent((int)(JetpackUtils.getThrottle(stack) * 100.0) + "%");
        tooltip.add((ITextComponent)ModTooltips.THROTTLE.args(new Object[]{throttle}).build());
        if (((Boolean)ModConfigs.ENABLE_ADVANCED_INFO_TOOLTIPS.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            if (!Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)Tooltips.HOLD_SHIFT_FOR_INFO.build());
            } else {
                tooltip.add((ITextComponent)ModTooltips.FUEL_USAGE.args(new Object[]{this.jetpack.usage + " FE/t"}).build());
                tooltip.add((ITextComponent)ModTooltips.VERTICAL_SPEED.args(new Object[]{this.jetpack.speedVert}).build());
                tooltip.add((ITextComponent)ModTooltips.VERTICAL_ACCELERATION.args(new Object[]{this.jetpack.accelVert}).build());
                tooltip.add((ITextComponent)ModTooltips.HORIZONTAL_SPEED.args(new Object[]{this.jetpack.speedSide}).build());
                tooltip.add((ITextComponent)ModTooltips.HOVER_SPEED.args(new Object[]{this.jetpack.speedHoverSlow}).build());
                tooltip.add((ITextComponent)ModTooltips.DESCEND_SPEED.args(new Object[]{this.jetpack.speedHover}).build());
                tooltip.add((ITextComponent)ModTooltips.SPRINT_MODIFIER.args(new Object[]{this.jetpack.sprintSpeed}).build());
                tooltip.add((ITextComponent)ModTooltips.SPRINT_VERTICAL_MODIFIER.args(new Object[]{this.jetpack.sprintSpeedVert}).build());
                tooltip.add((ITextComponent)ModTooltips.SPRINT_FUEL_MODIFIER.args(new Object[]{this.jetpack.sprintFuel}).build());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<?> getArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlotType slot, BipedModel _default) {
        if (this.model == null) {
            this.model = new JetpackModel(this);
        }
        return this.model;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return type == null ? "ironjetpacks:textures/armor/jetpack.png" : "ironjetpacks:textures/armor/jetpack_overlay.png";
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new EnergyCapabilityProvider((IEnergyStorage)new ItemEnergyStorage(stack, this.jetpack.capacity));
    }

    public int getColor(int i) {
        return i == 1 ? this.jetpack.color : -1;
    }

    public boolean func_200883_f_(ItemStack stack) {
        return true;
    }

    public int func_200886_f(ItemStack stack) {
        return this.jetpack.color;
    }

    public void func_200884_g(ItemStack stack) {
    }

    public void func_200885_a(ItemStack stack, int color) {
    }

    public boolean isEnabled() {
        return !this.jetpack.disabled;
    }

    public Jetpack getJetpack() {
        return this.jetpack;
    }

    private static void fly(PlayerEntity player, double y) {
        Vector3d motion = player.func_213322_ci();
        player.func_213293_j(motion.func_82615_a(), y, motion.func_82616_c());
    }
}

