/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.handler;

import com.blakebr0.ironjetpacks.handler.InputHandler;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.network.NetworkHandler;
import com.blakebr0.ironjetpacks.network.message.DecrementThrottleMessage;
import com.blakebr0.ironjetpacks.network.message.IncrementThrottleMessage;
import com.blakebr0.ironjetpacks.network.message.ToggleEngineMessage;
import com.blakebr0.ironjetpacks.network.message.ToggleHoverMessage;
import com.blakebr0.ironjetpacks.network.message.UpdateInputMessage;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public final class KeybindHandler {
    private static KeyBinding keyEngine;
    private static KeyBinding keyHover;
    private static KeyBinding keyDescend;
    private static KeyBinding keyIncrementThrottle;
    private static KeyBinding keyDecrementThrottle;
    private static boolean up;
    private static boolean down;
    private static boolean forwards;
    private static boolean backwards;
    private static boolean left;
    private static boolean right;
    private static boolean sprint;

    public static void onClientSetup() {
        keyEngine = new KeyBinding("keybind.ironjetpacks.engine", 86, "Iron Jetpacks");
        keyHover = new KeyBinding("keybind.ironjetpacks.hover", 71, "Iron Jetpacks");
        keyDescend = new KeyBinding("keybind.ironjetpacks.descend", InputMappings.field_197958_a.func_197937_c(), "Iron Jetpacks");
        keyIncrementThrottle = new KeyBinding("keybind.ironjetpacks.increment_throttle", 46, "Iron Jetpacks");
        keyDecrementThrottle = new KeyBinding("keybinding.ironjetpacks.decrement_throttle", 44, "Iron Jetpacks");
        ClientRegistry.registerKeyBinding((KeyBinding)keyEngine);
        ClientRegistry.registerKeyBinding((KeyBinding)keyHover);
        ClientRegistry.registerKeyBinding((KeyBinding)keyDescend);
        ClientRegistry.registerKeyBinding((KeyBinding)keyIncrementThrottle);
        ClientRegistry.registerKeyBinding((KeyBinding)keyDecrementThrottle);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        Item item = chest.func_77973_b();
        if (item instanceof JetpackItem) {
            KeybindHandler.handleInput((PlayerEntity)player, chest);
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        Item item = chest.func_77973_b();
        if (item instanceof JetpackItem) {
            KeybindHandler.handleInput((PlayerEntity)player, chest);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            GameSettings settings = mc.field_71474_y;
            if (mc.func_147114_u() == null) {
                return;
            }
            boolean upNow = settings.field_74314_A.func_151470_d();
            boolean downNow = keyDescend.func_197986_j() ? settings.field_228046_af_.func_151470_d() : keyDescend.func_151470_d();
            boolean forwardsNow = settings.field_74351_w.func_151470_d();
            boolean backwardsNow = settings.field_74368_y.func_151470_d();
            boolean leftNow = settings.field_74370_x.func_151470_d();
            boolean rightNow = settings.field_74366_z.func_151470_d();
            boolean sprintNow = settings.field_151444_V.func_151470_d();
            if (upNow != up || downNow != down || forwardsNow != forwards || backwardsNow != backwards || leftNow != left || rightNow != right || sprintNow != sprint) {
                up = upNow;
                down = downNow;
                forwards = forwardsNow;
                backwards = backwardsNow;
                left = leftNow;
                right = rightNow;
                sprint = sprintNow;
                NetworkHandler.INSTANCE.sendToServer((Object)new UpdateInputMessage(upNow, downNow, forwardsNow, backwardsNow, leftNow, rightNow, sprintNow));
                InputHandler.update((PlayerEntity)mc.field_71439_g, upNow, downNow, forwardsNow, backwardsNow, leftNow, rightNow, sprintNow);
            }
        }
    }

    private static void handleInput(PlayerEntity player, ItemStack stack) {
        IFormattableTextComponent throttleText;
        IFormattableTextComponent state;
        boolean on;
        if (keyEngine.func_151468_f()) {
            on = JetpackUtils.toggleEngine(stack);
            state = on ? ModTooltips.ON.color(TextFormatting.GREEN).build() : ModTooltips.OFF.color(TextFormatting.RED).build();
            NetworkHandler.INSTANCE.sendToServer((Object)new ToggleEngineMessage());
            player.func_146105_b((ITextComponent)ModTooltips.TOGGLE_ENGINE.args(new Object[]{state}).build(), true);
        }
        if (keyHover.func_151468_f()) {
            on = JetpackUtils.toggleHover(stack);
            state = on ? ModTooltips.ON.color(TextFormatting.GREEN).build() : ModTooltips.OFF.color(TextFormatting.RED).build();
            NetworkHandler.INSTANCE.sendToServer((Object)new ToggleHoverMessage());
            player.func_146105_b((ITextComponent)ModTooltips.TOGGLE_HOVER.args(new Object[]{state}).build(), true);
        }
        if (keyIncrementThrottle.func_151468_f()) {
            double throttle = JetpackUtils.incrementThrottle(stack);
            throttleText = new StringTextComponent((int)(throttle * 100.0) + "%").func_240699_a_(TextFormatting.GREEN);
            NetworkHandler.INSTANCE.sendToServer((Object)new IncrementThrottleMessage());
            player.func_146105_b((ITextComponent)ModTooltips.CHANGE_THROTTLE.args(new Object[]{throttleText}).build(), true);
        }
        if (keyDecrementThrottle.func_151468_f()) {
            double throttle = JetpackUtils.decrementThrottle(stack);
            throttleText = new StringTextComponent((int)(throttle * 100.0) + "%").func_240699_a_(TextFormatting.RED);
            NetworkHandler.INSTANCE.sendToServer((Object)new DecrementThrottleMessage());
            player.func_146105_b((ITextComponent)ModTooltips.CHANGE_THROTTLE.args(new Object[]{throttleText}).build(), true);
        }
    }

    static {
        up = false;
        down = false;
        forwards = false;
        backwards = false;
        left = false;
        right = false;
        sprint = false;
    }
}

