/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.tileentity;

import ironfurnaces.container.BlockWirelessEnergyHeaterContainer;
import ironfurnaces.energy.HeaterEnergyStorage;
import ironfurnaces.init.Registration;
import ironfurnaces.items.ItemHeater;
import ironfurnaces.tileentity.TileEntityInventory;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class BlockWirelessEnergyHeaterTile
extends TileEntityInventory
implements ITickableTileEntity {
    private HeaterEnergyStorage energyStorage = this.createEnergy();
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public BlockWirelessEnergyHeaterTile() {
        super((TileEntityType)Registration.HEATER_TILE.get(), 1);
    }

    private HeaterEnergyStorage createEnergy() {
        return new HeaterEnergyStorage(1000000, 1000000, 0){

            @Override
            protected void onEnergyChanged() {
                BlockWirelessEnergyHeaterTile.this.func_70296_d();
            }
        };
    }

    public void func_73660_a() {
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b()) {
            CompoundNBT nbt = new CompoundNBT();
            stack.func_77982_d(nbt);
            nbt.func_74768_a("X", this.field_174879_c.func_177958_n());
            nbt.func_74768_a("Y", this.field_174879_c.func_177956_o());
            nbt.func_74768_a("Z", this.field_174879_c.func_177952_p());
        }
    }

    public int getEnergy() {
        return this.getCapability(CapabilityEnergy.ENERGY).map(h -> h.getEnergyStored()).orElse(0);
    }

    public int getCapacity() {
        return this.getCapability(CapabilityEnergy.ENERGY).map(h -> h.getMaxEnergyStored()).orElse(0);
    }

    public void removeEnergy(int energy) {
        this.energy.ifPresent(h -> {
            if (h.getEnergyStored() >= energy) {
                ((HeaterEnergyStorage)((Object)h)).setEnergy(h.getEnergyStored() - energy);
            }
        });
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.energy.ifPresent(h -> ((HeaterEnergyStorage)((Object)h)).setEnergy(nbt.func_74762_e("Energy")));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Energy", this.getEnergy());
        return compound;
    }

    @Override
    public int[] IgetSlotsForFace(Direction side) {
        return new int[0];
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public String IgetName() {
        return "container.ironfurnaces.wireless_energy_heater";
    }

    @Override
    public boolean IisItemValidForSlot(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemHeater;
    }

    @Override
    public Container IcreateMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new BlockWirelessEnergyHeaterContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.func_145837_r() && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        if (!this.func_145837_r() && capability == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        this.energy.invalidate();
        super.func_145843_s();
    }
}

