/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.item;

import com.progwml6.ironchest.common.block.GenericIronChestBlock;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.tileentity.GenericIronChestTileEntity;
import com.progwml6.ironchest.common.item.IronChestsUpgradeType;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChestUpgradeItem
extends Item {
    private final IronChestsUpgradeType type;

    public ChestUpgradeItem(IronChestsUpgradeType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity entityPlayer = context.func_195999_j();
        BlockPos blockPos = context.func_195995_a();
        World world = context.func_195991_k();
        ItemStack itemStack = context.func_195996_i();
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        if (entityPlayer == null) {
            return ActionResultType.PASS;
        }
        if (this.type.canUpgrade(IronChestsTypes.WOOD) ? !(world.func_180495_p(blockPos).func_177230_c() instanceof ChestBlock) : world.func_180495_p(blockPos).func_177230_c().func_176223_P() != IronChestsTypes.get(this.type.source).func_176223_P()) {
            return ActionResultType.PASS;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (this.type.canUpgrade(IronChestsTypes.WOOD) && !(tileEntity instanceof ChestTileEntity)) {
            return ActionResultType.PASS;
        }
        GenericIronChestTileEntity newChest = null;
        ITextComponent customName = null;
        NonNullList chestContents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        Direction chestFacing = Direction.NORTH;
        if (tileEntity != null) {
            if (tileEntity instanceof GenericIronChestTileEntity) {
                GenericIronChestTileEntity chest = (GenericIronChestTileEntity)tileEntity;
                BlockState chestState = world.func_180495_p(blockPos);
                if (GenericIronChestTileEntity.getPlayersUsing((IBlockReader)world, blockPos) > 0) {
                    return ActionResultType.PASS;
                }
                if (!chest.func_213904_e(entityPlayer)) {
                    return ActionResultType.PASS;
                }
                chestContents = chest.func_190576_q();
                chestFacing = (Direction)chestState.func_177229_b((Property)GenericIronChestBlock.FACING);
                customName = chest.func_200201_e();
                newChest = this.type.target.makeEntity();
                if (newChest == null) {
                    return ActionResultType.PASS;
                }
            } else if (tileEntity instanceof ChestTileEntity) {
                BlockState chestState = world.func_180495_p(blockPos);
                chestFacing = (Direction)chestState.func_177229_b((Property)ChestBlock.field_176459_a);
                ChestTileEntity chest = (ChestTileEntity)tileEntity;
                if (ChestTileEntity.func_195481_a((IBlockReader)world, (BlockPos)blockPos) > 0) {
                    return ActionResultType.PASS;
                }
                if (!chest.func_213904_e(entityPlayer)) {
                    return ActionResultType.PASS;
                }
                if (!this.type.canUpgrade(IronChestsTypes.WOOD)) {
                    return ActionResultType.PASS;
                }
                chestContents = NonNullList.func_191197_a((int)chest.func_70302_i_(), (Object)ItemStack.field_190927_a);
                for (int slot = 0; slot < chestContents.size(); ++slot) {
                    chestContents.set(slot, (Object)chest.func_70301_a(slot));
                }
                customName = chest.func_200201_e();
                newChest = this.type.target.makeEntity();
            }
        }
        tileEntity.func_145836_u();
        world.func_175713_t(blockPos);
        world.func_217377_a(blockPos, false);
        BlockState iBlockState = (BlockState)IronChestsTypes.get(this.type.target).func_176223_P().func_206870_a((Property)GenericIronChestBlock.FACING, (Comparable)chestFacing);
        world.func_180501_a(blockPos, iBlockState, 3);
        world.func_175690_a(blockPos, newChest);
        world.func_184138_a(blockPos, iBlockState, iBlockState, 3);
        TileEntity tileEntity2 = world.func_175625_s(blockPos);
        if (tileEntity2 instanceof GenericIronChestTileEntity) {
            if (customName != null) {
                ((GenericIronChestTileEntity)tileEntity2).func_213903_a(customName);
            }
            ((GenericIronChestTileEntity)tileEntity2).func_199721_a((NonNullList<ItemStack>)chestContents);
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }
}

