/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.util;

import com.google.common.base.Equivalence;
import com.google.common.collect.Streams;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class Utils {
    public static final Equivalence<ItemStack> STACKABLE = new Equivalence<ItemStack>(){

        @ParametersAreNonnullByDefault
        protected boolean doEquivalent(ItemStack a, ItemStack b) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b);
        }

        protected int doHash(ItemStack t) {
            ArrayList<Object> objs = new ArrayList<Object>(2);
            if (!t.func_190926_b()) {
                objs.add(t.func_77973_b());
                if (t.func_77942_o()) {
                    objs.add(t.func_77978_p());
                }
            }
            return Arrays.hashCode(objs.toArray());
        }
    };
    public static final Comparator<ItemStack> FALLBACK_COMPARATOR = Comparator.comparing(is -> is.func_77973_b().getRegistryName());

    public static int gridToPlayerSlot(int row, int col) {
        if (row < 0 || row >= 4 || col < 0 || col >= 9) {
            throw new IllegalArgumentException("Invalid coordinates (" + row + ", " + col + ")");
        }
        return (row + 1) % 4 * 9 + col;
    }

    public static int gridRowToInt(String str) {
        if (str.length() != 1 || str.charAt(0) < 'A' || str.charAt(0) > 'D') {
            throw new IllegalArgumentException("Invalid grid row: " + str);
        }
        return str.charAt(0) - 65;
    }

    public static int gridColToInt(String str) {
        if (str.length() != 1 || str.charAt(0) < '1' || str.charAt(0) > '9') {
            throw new IllegalArgumentException("Invalid grid column: " + str);
        }
        return str.charAt(0) - 49;
    }

    public static int[] gridSpecToSlots(String str, boolean global) {
        String[] parts;
        if (str.endsWith("rv")) {
            return Utils.gridSpecToSlots(str.substring(0, str.length() - 2) + "vr", global);
        }
        if (str.endsWith("r")) {
            return IntArrays.reverse((int[])Utils.gridSpecToSlots(str.substring(0, str.length() - 1), global));
        }
        boolean vertical = false;
        if (str.endsWith("v")) {
            vertical = true;
            str = str.substring(0, str.length() - 1);
        }
        if ((parts = str.split("-")).length == 1) {
            if (str.length() == 1) {
                try {
                    int row2 = Utils.gridRowToInt(str);
                    if (global) {
                        return Utils.gridSpecToSlots("A1-D9", false);
                    }
                    return IntStream.rangeClosed(0, 8).map(col -> Utils.gridToPlayerSlot(row2, col)).toArray();
                }
                catch (IllegalArgumentException e) {
                    int col2 = Utils.gridColToInt(str);
                    if (global) {
                        return Utils.gridSpecToSlots("D1-A9v", false);
                    }
                    return Utils.directedRangeInclusive(3, 0).map(row -> Utils.gridToPlayerSlot(row, col2)).toArray();
                }
            }
            if (str.length() == 2) {
                if (global) {
                    return Utils.gridSpecToSlots("A1-D9", false);
                }
                return new int[]{Utils.gridToPlayerSlot(Utils.gridRowToInt(str.substring(0, 1)), Utils.gridColToInt(str.substring(1, 2)))};
            }
            throw new IllegalArgumentException("Bad grid spec: " + str);
        }
        if (parts.length == 2) {
            if (parts[0].length() == 2 && parts[1].length() == 2) {
                int row0 = Utils.gridRowToInt(parts[0].substring(0, 1));
                int col0 = Utils.gridColToInt(parts[0].substring(1, 2));
                int row1 = Utils.gridRowToInt(parts[1].substring(0, 1));
                int col1 = Utils.gridColToInt(parts[1].substring(1, 2));
                if (global) {
                    if (row0 > row1) {
                        row0 = 3;
                        row1 = 0;
                    } else {
                        row0 = 0;
                        row1 = 3;
                    }
                    if (col0 > col1) {
                        col0 = 8;
                        col1 = 0;
                    } else {
                        col0 = 0;
                        col1 = 8;
                    }
                }
                int _row0 = row0;
                int _row1 = row1;
                int _col0 = col0;
                int _col1 = col1;
                if (vertical) {
                    return Utils.directedRangeInclusive(col0, col1).flatMap(col -> Utils.directedRangeInclusive(_row0, _row1).map(row -> Utils.gridToPlayerSlot(row, col))).toArray();
                }
                return Utils.directedRangeInclusive(row0, row1).flatMap(row -> Utils.directedRangeInclusive(_col0, _col1).map(col -> Utils.gridToPlayerSlot(row, col))).toArray();
            }
            throw new IllegalArgumentException("Bad grid spec: " + str);
        }
        throw new IllegalArgumentException("Bad grid spec: " + str);
    }

    public static IntStream directedRangeInclusive(int start, int end) {
        return IntStream.iterate(start, v -> start > end ? v - 1 : v + 1).limit(Math.abs(end - start) + 1);
    }

    public static <T extends Collection<ItemStack>> T collated(Iterable<ItemStack> iterable, Supplier<T> collSupp) {
        Map mapping = Streams.stream(iterable).collect(Collectors.groupingBy(arg_0 -> STACKABLE.wrap(arg_0), LinkedHashMap::new, Collectors.toList()));
        return (T)((Collection)mapping.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(collSupp)));
    }

    public static Map<Equivalence.Wrapper<ItemStack>, Set<Slot>> gatheredSlots(Iterable<Slot> iterable) {
        return Streams.stream(iterable).collect(Collectors.groupingBy(sl -> STACKABLE.wrap((Object)sl.func_75211_c().func_77946_l()), LinkedHashMap::new, Collectors.toCollection(ObjectLinkedOpenHashSet::new)));
    }

    public static List<ItemStack> condensed(Iterable<ItemStack> iterable) {
        List coll = Utils.collated(iterable, ArrayList::new);
        ItemStackHandler stackBuffer = new ItemStackHandler(coll.size());
        int index = 0;
        for (ItemStack stack : coll) {
            stack = stack.func_77946_l();
            while (!(stack = stackBuffer.insertItem(index, stack, false)).func_190926_b()) {
                ++index;
            }
        }
        return IntStream.range(0, stackBuffer.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)stackBuffer).getStackInSlot(arg_0)).filter(is -> !is.func_190926_b()).collect(Collectors.toList());
    }
}

