/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.packets;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import invtweaks.config.InvTweaksConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateConfig {
    private final List<UnmodifiableConfig> cats;
    private final List<String> rules;
    private final List<UnmodifiableConfig> contOverrides;
    private final boolean autoRefill;

    public PacketUpdateConfig() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false);
    }

    public PacketUpdateConfig(List<UnmodifiableConfig> cats, List<String> rules, List<UnmodifiableConfig> contOverrides, boolean autoRefill) {
        this.cats = cats;
        this.rules = rules;
        this.autoRefill = autoRefill;
        this.contOverrides = contOverrides;
    }

    public PacketUpdateConfig(PacketBuffer buf) {
        this.cats = new ArrayList<UnmodifiableConfig>();
        int catsSize = buf.func_150792_a();
        for (int i = 0; i < catsSize; ++i) {
            CommentedConfig subCfg = CommentedConfig.inMemory();
            subCfg.set("name", (Object)buf.func_150789_c(Short.MAX_VALUE));
            ArrayList<String> spec = new ArrayList<String>();
            int specSize = buf.func_150792_a();
            for (int j = 0; j < specSize; ++j) {
                spec.add(buf.func_150789_c(Short.MAX_VALUE));
            }
            subCfg.set("spec", spec);
            this.cats.add((UnmodifiableConfig)subCfg);
        }
        this.rules = new ArrayList<String>();
        int rulesSize = buf.func_150792_a();
        for (int i = 0; i < rulesSize; ++i) {
            this.rules.add(buf.func_150789_c(Short.MAX_VALUE));
        }
        this.contOverrides = new ArrayList<UnmodifiableConfig>();
        int contOverridesSize = buf.func_150792_a();
        for (int i = 0; i < contOverridesSize; ++i) {
            CommentedConfig contOverride = CommentedConfig.inMemory();
            contOverride.set("containerClass", (Object)buf.func_150789_c(Short.MAX_VALUE));
            contOverride.set("x", (Object)buf.readInt());
            contOverride.set("y", (Object)buf.readInt());
            contOverride.set("sortRange", (Object)buf.func_150789_c(Short.MAX_VALUE));
            this.contOverrides.add((UnmodifiableConfig)contOverride);
        }
        this.autoRefill = buf.readBoolean();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            InvTweaksConfig.setPlayerCats((PlayerEntity)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()), InvTweaksConfig.cfgToCompiledCats(this.cats));
            InvTweaksConfig.setPlayerRules((PlayerEntity)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()), new InvTweaksConfig.Ruleset(this.rules));
            InvTweaksConfig.setPlayerAutoRefill((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), this.autoRefill);
            InvTweaksConfig.setPlayerContOverrides((PlayerEntity)Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender()), InvTweaksConfig.cfgToCompiledContOverrides(this.contOverrides));
        });
        ctx.get().setPacketHandled(true);
    }

    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.cats.size());
        for (UnmodifiableConfig subCfg : this.cats) {
            buf.func_180714_a((String)subCfg.getOrElse("name", (Object)""));
            List spec = (List)subCfg.getOrElse("spec", Collections.emptyList());
            buf.func_150787_b(spec.size());
            for (String subSpec : spec) {
                buf.func_180714_a(subSpec);
            }
        }
        buf.func_150787_b(this.rules.size());
        for (String subRule : this.rules) {
            buf.func_180714_a(subRule);
        }
        buf.func_150787_b(this.contOverrides.size());
        for (UnmodifiableConfig contOverride : this.contOverrides) {
            buf.func_180714_a((String)contOverride.getOrElse("containerClass", (Object)""));
            int x = contOverride.getIntOrElse("x", -1418392593);
            int y = contOverride.getIntOrElse("y", -1418392593);
            buf.writeInt(x).writeInt(y);
            buf.func_180714_a((String)contOverride.getOrElse("sortRange", (Object)"default"));
        }
        buf.writeBoolean(this.autoRefill);
    }
}

