/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientCraftingOptionsPacket
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private CompoundNBT data;
    @CodecField
    private boolean reset;
    @CodecField
    private boolean firstChannel;

    public TerminalStorageIngredientCraftingOptionsPacket() {
    }

    public <T> TerminalStorageIngredientCraftingOptionsPacket(String tabId, int channel, List<HandlerWrappedTerminalCraftingOption<T>> craftingOptions, boolean reset, boolean firstChannel) {
        this.tabId = tabId;
        this.channel = channel;
        this.data = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (HandlerWrappedTerminalCraftingOption<T> option : craftingOptions) {
            list.add((Object)HandlerWrappedTerminalCraftingOption.serialize(option));
        }
        this.data.func_218657_a("craftingOptions", (INBT)list);
        this.reset = reset;
        this.firstChannel = firstChannel;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
        if (player.field_71070_bA instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.field_71070_bA;
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            IngredientComponent ingredientComponent = tab.getIngredientComponent();
            ListNBT list = this.data.func_150295_c("craftingOptions", 10);
            ArrayList craftingOptions = Lists.newArrayListWithExpectedSize((int)list.size());
            for (int i = 0; i < list.size(); ++i) {
                HandlerWrappedTerminalCraftingOption option = HandlerWrappedTerminalCraftingOption.deserialize(ingredientComponent, list.func_150305_b(i));
                craftingOptions.add(option);
            }
            tab.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
            if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                tabCrafting.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
            }
            container.refreshChannelStrings();
        }
    }

    public void actionServer(World world, ServerPlayerEntity player) {
    }
}

