/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class ItemTerminalStoragePortable
extends ItemGui {
    public static String NBT_KEY_GROUP = "integratedterminals:groupKey";
    public static String NBT_KEY_NAMED_INVENTORIES = "integratedterminals:namedInventories";
    public static String NBT_KEY_STATES = "integratedterminals:terminalStorageStates";

    public ItemTerminalStoragePortable(Item.Properties properties) {
        super(properties);
    }

    public void openGuiForItemIndex(World world, ServerPlayerEntity player, int itemIndex, Hand hand) {
        if (world.func_201670_d()) {
            super.openGuiForItemIndex(world, player, itemIndex, hand);
        } else {
            ItemStack itemStack = InventoryHelpers.getItemFromIndex((PlayerEntity)player, (int)itemIndex, (Hand)hand);
            int groupId = ItemTerminalStoragePortable.getGroupId(itemStack);
            if (groupId >= 0) {
                Optional<INetwork> network = ContainerTerminalStorageItem.getNetworkFromItem(itemStack);
                if (network.isPresent()) {
                    super.openGuiForItemIndex(world, player, itemIndex, hand);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.integratedterminals.terminal_storage_portable.status.invalid_network"), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("item.integratedterminals.terminal_storage_portable.status.no_network"), true);
            }
        }
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PartPos partPos;
        PartHelpers.PartStateHolder partStateHolder;
        if (!context.func_195991_k().func_201670_d() && (partStateHolder = PartHelpers.getPart((PartPos)(partPos = PartPos.of((World)context.func_195991_k(), (BlockPos)context.func_195995_a(), (Direction)context.func_196000_l())))) != null && partStateHolder.getPart() == PartTypes.CONNECTOR_OMNI) {
            PartTypeConnectorOmniDirectional.State state = (PartTypeConnectorOmniDirectional.State)partStateHolder.getState();
            ItemTerminalStoragePortable.setGroupId(stack, state.getGroupId());
            context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("item.integratedterminals.terminal_storage_portable.status.linked"), true);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public INamedContainerProvider getContainer(World world, PlayerEntity playerEntity, int itemIndex, Hand hand, ItemStack itemStack) {
        return new NamedContainerProviderItem(itemIndex, hand, itemStack.func_200301_q(), (id, playerInventory, slot, hand1) -> new ContainerTerminalStorageItem(id, playerInventory, slot, hand1, Optional.empty(), ItemTerminalStoragePortable.getTerminalStorageState(InventoryHelpers.getItemFromIndex((PlayerEntity)playerEntity, (int)itemIndex, (Hand)hand), playerEntity, itemIndex, hand)));
    }

    public Class<? extends Container> getContainerClass(World world, PlayerEntity playerEntity, ItemStack itemStack) {
        return ContainerTerminalStorageItem.class;
    }

    public void writeExtraGuiData(PacketBuffer packetBuffer, World world, ServerPlayerEntity player, int itemIndex, Hand hand) {
        super.writeExtraGuiData(packetBuffer, world, player, itemIndex, hand);
        packetBuffer.writeBoolean(false);
        ItemTerminalStoragePortable.getTerminalStorageState(InventoryHelpers.getItemFromIndex((PlayerEntity)player, (int)itemIndex, (Hand)hand), (PlayerEntity)player, itemIndex, hand).writeToPacketBuffer(packetBuffer);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int groupId = ItemTerminalStoragePortable.getGroupId(stack);
        if (groupId >= 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("parttype.integrateddynamics.tooltip.monodirectionalconnector.group", new Object[]{groupId}));
        }
    }

    public static int getGroupId(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag == null || !tag.func_150297_b(NBT_KEY_GROUP, 3)) {
            return -1;
        }
        return tag.func_74762_e(NBT_KEY_GROUP);
    }

    public static void setGroupId(ItemStack itemStack, int groupId) {
        CompoundNBT tag = itemStack.func_196082_o();
        tag.func_74768_a(NBT_KEY_GROUP, groupId);
    }

    public static ITerminalStorageTabCommon.IVariableInventory getVariableInventory(ItemStack itemStack) {
        CompoundNBT tagRoot = itemStack.func_196082_o();
        if (!tagRoot.func_150297_b(NBT_KEY_NAMED_INVENTORIES, 10)) {
            tagRoot.func_218657_a(NBT_KEY_NAMED_INVENTORIES, (INBT)new CompoundNBT());
        }
        final CompoundNBT tagInventories = tagRoot.func_74775_l(NBT_KEY_NAMED_INVENTORIES);
        return new ITerminalStorageTabCommon.IVariableInventory(){

            @Override
            public NonNullList<ItemStack> getNamedInventory(String name) {
                CompoundNBT tag = tagInventories.func_74775_l(name);
                NonNullList list = NonNullList.func_191197_a((int)tag.func_74762_e("itemCount"), (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)list);
                return list;
            }

            @Override
            public void setNamedInventory(String name, NonNullList<ItemStack> inventory) {
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("tabName", name);
                tag.func_74768_a("itemCount", inventory.size());
                ItemStackHelper.func_191282_a((CompoundNBT)tag, inventory);
                tagInventories.func_218657_a(name, (INBT)tag);
            }
        };
    }

    public static TerminalStorageState getTerminalStorageState(ItemStack itemStack, PlayerEntity player, int slot, Hand hand) {
        CompoundNBT tagRoot = itemStack.func_196082_o();
        if (!tagRoot.func_150297_b(NBT_KEY_STATES, 10)) {
            tagRoot.func_218657_a(NBT_KEY_STATES, (INBT)new CompoundNBT());
        }
        CompoundNBT tagStates = tagRoot.func_74775_l(NBT_KEY_STATES);
        String playerKey = player.func_110124_au().toString();
        Wrapper stateWrapped = new Wrapper();
        IDirtyMarkListener dirtyMarkListener = () -> tagStates.func_218657_a(playerKey, (INBT)((TerminalStorageState)stateWrapped.get()).getTag());
        if (!tagStates.func_150297_b(playerKey, 10)) {
            TerminalStorageState state = TerminalStorageState.getPlayerDefault(player, dirtyMarkListener);
            stateWrapped.set((Object)state);
            tagStates.func_218657_a(playerKey, (INBT)state.getTag());
            return state;
        }
        TerminalStorageState state = new TerminalStorageState(tagStates.func_74775_l(playerKey), dirtyMarkListener);
        stateWrapped.set((Object)state);
        return state;
    }
}

