/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.CraftingJobStartException;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;

public abstract class ContainerTerminalStorageCraftingPlanBase<L>
extends InventoryContainer {
    public static final String BUTTON_START = "start";
    private static final ExecutorService WORKER_POOL = Executors.newFixedThreadPool(GeneralConfig.craftingPlannerThreads);
    private final CraftingOptionGuiData craftingOptionGuiData;
    private final int craftingPlanNotifierId;
    private final World world;
    private boolean calculatedCraftingPlan;
    private ITerminalCraftingPlan craftingPlan;

    public ContainerTerminalStorageCraftingPlanBase(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, CraftingOptionGuiData craftingOptionGuiData) {
        super(type, id, playerInventory, (IInventory)new Inventory(new ItemStack[0]));
        this.craftingOptionGuiData = craftingOptionGuiData;
        this.craftingPlanNotifierId = this.getNextValueId();
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.putButtonAction(BUTTON_START, (buttonId, container) -> this.startCraftingJob());
    }

    public abstract Optional<INetwork> getNetwork();

    public World getWorld() {
        return this.world;
    }

    public CraftingOptionGuiData getCraftingOptionGuiData() {
        return this.craftingOptionGuiData;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.player.field_70170_p.field_72995_K && !this.calculatedCraftingPlan) {
            this.calculatedCraftingPlan = true;
            this.updateCraftingPlan();
        }
    }

    public int getCraftingPlanNotifierId() {
        return this.craftingPlanNotifierId;
    }

    protected void updateCraftingPlan() {
        HandlerWrappedTerminalCraftingOption craftingOptionWrapper = this.craftingOptionGuiData.getCraftingOption();
        this.getNetwork().ifPresent(network -> {
            if (GeneralConfig.craftingPlannerEnableMultithreading) {
                WORKER_POOL.execute(() -> {
                    TileHelpers.UNSAFE_TILE_ENTITY_GETTER = true;
                    this.updateCraftingPlanJob(craftingOptionWrapper, (INetwork)network);
                    TileHelpers.UNSAFE_TILE_ENTITY_GETTER = false;
                });
            } else {
                this.updateCraftingPlanJob(craftingOptionWrapper, (INetwork)network);
            }
        });
    }

    protected void updateCraftingPlanJob(HandlerWrappedTerminalCraftingOption craftingOptionWrapper, INetwork network) {
        this.setCraftingPlan(craftingOptionWrapper.getHandler().calculateCraftingPlan(network, this.craftingOptionGuiData.getChannel(), craftingOptionWrapper.getCraftingOption(), this.craftingOptionGuiData.getAmount()));
    }

    protected void setCraftingPlan(ITerminalCraftingPlan craftingPlan) {
        this.craftingPlan = craftingPlan;
        this.setValue(this.craftingPlanNotifierId, this.craftingOptionGuiData.getCraftingOption().getHandler().serializeCraftingPlan(this.craftingPlan));
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    private void startCraftingJob() {
        if (!this.getWorld().func_201670_d() && this.craftingPlan != null) {
            this.getNetwork().ifPresent(network -> {
                try {
                    this.craftingOptionGuiData.getCraftingOption().getHandler().startCraftingJob((INetwork)network, this.craftingOptionGuiData.getChannel(), this.craftingPlan, (ServerPlayerEntity)this.player);
                    this.craftingOptionGuiData.getLocation().openContainerFromServer(this.craftingOptionGuiData, this.getWorld(), (ServerPlayerEntity)this.player);
                }
                catch (CraftingJobStartException e) {
                    this.craftingPlan.setError(e.getUnlocalizedError());
                    this.setCraftingPlan(this.craftingPlan);
                }
            });
        }
    }
}

