/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTab;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabServer;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabCommonLoadSlotsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabs;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.network.packet.TerminalStorageChangeGuiState;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingJobAmountGuiPacket;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingPlanGuiPacket;

public abstract class ContainerTerminalStorageBase<L>
extends InventoryContainer
implements IDirtyMarkListener {
    public static final String BUTTON_SET_DEFAULTS = "button_set_defaults";
    private final World world;
    private final Map<String, ITerminalStorageTabClient<?>> tabsClient;
    private final Map<String, ITerminalStorageTabServer> tabsServer;
    private final Map<String, ITerminalStorageTabCommon> tabsCommon;
    private final Map<String, List<Triple<Slot, Integer, Integer>>> tabSlots;
    private final TerminalStorageState terminalStorageState;
    private final Optional<INetwork> network;
    private final Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventory;
    private int selectedTabIndexValueId;
    private int selectedChannelValueId;
    private boolean serverTabsInitialized;
    private final List<String> channelStrings;
    private String channelAllLabel;

    public ContainerTerminalStorageBase(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, Optional<InitTabData> initTabData, TerminalStorageState terminalStorageState, Optional<INetwork> network, Optional<ITerminalStorageTabCommon.IVariableInventory> variableInventory) {
        super(type, id, playerInventory, (IInventory)new Inventory(new ItemStack[0]));
        this.world = this.player.func_130014_f_();
        this.tabsClient = Maps.newLinkedHashMap();
        this.tabsServer = Maps.newLinkedHashMap();
        this.tabsCommon = Maps.newLinkedHashMap();
        this.tabSlots = Maps.newHashMap();
        this.terminalStorageState = terminalStorageState;
        this.network = network;
        this.variableInventory = variableInventory;
        this.selectedTabIndexValueId = this.getNextValueId();
        this.selectedChannelValueId = this.getNextValueId();
        this.serverTabsInitialized = false;
        this.addPlayerInventory(this.player.field_71071_by, 31, 143);
        this.channelAllLabel = "All";
        this.channelStrings = Lists.newArrayList((Object[])new String[]{this.channelAllLabel});
        for (ITerminalStorageTab tab : TerminalStorageTabs.REGISTRY.getTabs()) {
            ITerminalStorageTabCommon commonTab;
            String tabId = tab.getName().toString();
            if (this.getWorld().func_201670_d()) {
                this.tabsClient.put(tabId, tab.createClientTab(this, this.player));
            } else {
                this.tabsServer.put(tabId, tab.createServerTab(this, this.player, network.get()));
            }
            if ((commonTab = tab.createCommonTab(this, this.player)) == null) continue;
            this.tabsCommon.put(tabId, commonTab);
            int slotStartIndex = this.field_75151_b.size();
            List<Slot> slots = commonTab.loadSlots((Container)this, slotStartIndex, this.player, this.getVariableInventory());
            TerminalStorageTabCommonLoadSlotsEvent loadSlotsEvent = new TerminalStorageTabCommonLoadSlotsEvent(commonTab, this, slots);
            MinecraftForge.EVENT_BUS.post((Event)loadSlotsEvent);
            slots = loadSlotsEvent.getSlots();
            this.tabSlots.put(tabId, slots.stream().map(slot -> Triple.of((Object)slot, (Object)slot.field_75223_e, (Object)slot.field_75221_f)).collect(Collectors.toList()));
            for (Slot slot2 : slots) {
                if (slot2.field_75222_d != 0) continue;
                this.func_75146_a(slot2);
            }
        }
        for (ITerminalStorageTabCommon tabCommon : this.tabsCommon.values()) {
            this.disableSlots(tabCommon.getName().toString());
        }
        if (this.player.field_70170_p.func_201670_d()) {
            TerminalStorageState state = this.getGuiState();
            this.setSelectedTab(state.hasTab() ? state.getTab() : (this.getTabsClient().size() > 0 ? ((ITerminalStorageTabClient)Iterables.getFirst(this.getTabsClient().values(), null)).getName().toString() : null));
            this.setSelectedChannel(-1);
        } else {
            this.setSelectedTab(null);
            this.setSelectedChannel(-1);
        }
        initTabData.ifPresent(d -> {
            this.setSelectedTab(d.getTabName());
            this.setSelectedChannel(d.getChannel());
        });
        this.putButtonAction(BUTTON_SET_DEFAULTS, (s, containerExtended) -> {
            if (!playerInventory.field_70458_d.field_70170_p.func_201670_d()) {
                TerminalStorageState.setPlayerDefault(playerInventory.field_70458_d, this.getGuiState());
            }
        });
    }

    public Optional<ITerminalStorageTabCommon.IVariableInventory> getVariableInventory() {
        return this.variableInventory;
    }

    public Optional<INetwork> getNetwork() {
        return this.network;
    }

    public abstract ITerminalStorageLocation<L> getLocation();

    public abstract L getLocationInstance();

    public void onDirty() {
    }

    public World getWorld() {
        return this.world;
    }

    public TerminalStorageState getGuiState() {
        return this.terminalStorageState;
    }

    public void sendGuiStateToServer() {
        if (this.player.field_70170_p.func_201670_d()) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageChangeGuiState(this.getGuiState()));
        }
    }

    public int getNextValueId() {
        return super.getNextValueId();
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.serverTabsInitialized) {
            for (ITerminalStorageTabServer iTerminalStorageTabServer : this.tabsServer.values()) {
                iTerminalStorageTabServer.init();
            }
            this.serverTabsInitialized = true;
        }
        for (ITerminalStorageTabCommon iTerminalStorageTabCommon : this.tabsCommon.values()) {
            iTerminalStorageTabCommon.onUpdate((Container)this, this.player, this.getVariableInventory());
        }
        ITerminalStorageTabServer activeServerTab = this.getTabServer(this.getSelectedTab());
        if (activeServerTab != null) {
            activeServerTab.updateActive();
        }
    }

    public <T, M, L> void sendOpenCraftingPlanGuiPacketToServer(CraftingOptionGuiData<T, M, L> craftingOptionData) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingPlanGuiPacket<T, M, L>(craftingOptionData));
    }

    public <T, M, L> void sendOpenCraftingJobAmountGuiPacketToServer(CraftingOptionGuiData<T, M, L> craftingOptionData) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingJobAmountGuiPacket<T, M, L>(craftingOptionData));
    }

    public void func_75130_a(IInventory inventoryIn) {
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!this.getWorld().func_201670_d() && this.serverTabsInitialized) {
            for (ITerminalStorageTabServer tab : this.tabsServer.values()) {
                tab.deInit();
            }
        }
    }

    protected int getSizeInventory() {
        return this.field_75151_b.size() - this.player.field_71071_by.field_70462_a.size();
    }

    public List<Triple<Slot, Integer, Integer>> getTabSlots(String tabName) {
        List<Triple<Slot, Integer, Integer>> slots = this.tabSlots.get(tabName);
        if (slots == null) {
            return Collections.emptyList();
        }
        return slots;
    }

    protected void enableSlots(String tabName) {
        List<Triple<Slot, Integer, Integer>> slots = this.getTabSlots(tabName);
        if (slots != null) {
            for (Triple<Slot, Integer, Integer> slot : slots) {
                ContainerTerminalStorageBase.setSlotPosX((Slot)((Slot)slot.getLeft()), (int)((Integer)slot.getMiddle()));
                ContainerTerminalStorageBase.setSlotPosY((Slot)((Slot)slot.getLeft()), (int)((Integer)slot.getRight()));
            }
        }
    }

    protected void disableSlots(String tabName) {
        List<Triple<Slot, Integer, Integer>> slots = this.getTabSlots(tabName);
        if (slots != null) {
            for (Triple<Slot, Integer, Integer> slot : slots) {
                ContainerTerminalStorageBase.setSlotPosX((Slot)((Slot)slot.getLeft()), (int)Integer.MIN_VALUE);
                ContainerTerminalStorageBase.setSlotPosY((Slot)((Slot)slot.getLeft()), (int)Integer.MIN_VALUE);
            }
        }
    }

    public void setSelectedTab(@Nullable String selectedTab) {
        this.disableSlots(this.getSelectedTab());
        if (this.player.field_70170_p.field_72995_K) {
            ITerminalStorageTabClient previousTab = this.getTabClient(this.getSelectedTab());
            if (previousTab != null) {
                previousTab.onDeselect(this.getSelectedChannel());
            }
            this.getGuiState().setTab(selectedTab);
            ITerminalStorageTabClient newTab = this.getTabClient(selectedTab);
            if (newTab != null) {
                newTab.onSelect(this.getSelectedChannel());
            }
        }
        if (selectedTab != null) {
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.selectedTabIndexValueId, (String)selectedTab);
        }
        this.enableSlots(this.getSelectedTab());
    }

    @Nullable
    public String getSelectedTab() {
        return ValueNotifierHelpers.getValueString((IValueNotifier)this, (int)this.selectedTabIndexValueId);
    }

    public void setSelectedChannel(int selectedChannel) {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.selectedChannelValueId, (int)selectedChannel);
        this.refreshChannelStrings();
    }

    public int getSelectedChannel() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.selectedChannelValueId);
    }

    @Nullable
    public ITerminalStorageTabClient getTabClient(String id) {
        return this.tabsClient.get(id);
    }

    @Nullable
    public ITerminalStorageTabServer getTabServer(String id) {
        return this.tabsServer.get(id);
    }

    @Nullable
    public ITerminalStorageTabCommon getTabCommon(String id) {
        return this.tabsCommon.get(id);
    }

    public int getTabsClientCount() {
        return this.getTabsClient().size();
    }

    public Map<String, ITerminalStorageTabClient<?>> getTabsClient() {
        LinkedHashMap tabs = Maps.newLinkedHashMap();
        for (Map.Entry<String, ITerminalStorageTabClient<?>> entry : this.tabsClient.entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            tabs.put(entry.getKey(), entry.getValue());
        }
        return tabs;
    }

    public Map<String, ITerminalStorageTabCommon> getTabsCommon() {
        LinkedHashMap tabs = Maps.newLinkedHashMap();
        for (Map.Entry<String, ITerminalStorageTabCommon> entry : this.tabsCommon.entrySet()) {
            tabs.put(entry.getKey(), entry.getValue());
        }
        return tabs;
    }

    public Map<String, ITerminalStorageTabServer> getTabsServer() {
        return this.tabsServer;
    }

    public List<String> getChannelStrings() {
        return this.channelStrings;
    }

    public void refreshChannelStrings() {
        this.channelStrings.clear();
        this.channelStrings.add(this.channelAllLabel);
        ITerminalStorageTabClient<?> tab = this.tabsClient.get(this.getSelectedTab());
        if (tab != null) {
            for (int channel : tab.getChannels()) {
                this.channelStrings.add(String.valueOf(channel));
            }
        }
    }

    public abstract void onVariableContentsUpdated(INetwork var1, IVariable<?> var2);

    public static class InitTabData {
        private final String tabName;
        private final int channel;

        public InitTabData(String tabName, int channel) {
            this.tabName = tabName;
            this.channel = channel;
        }

        public String getTabName() {
            return this.tabName;
        }

        public int getChannel() {
            return this.channel;
        }

        public void writeToPacketBuffer(PacketBuffer packetBuffer) {
            packetBuffer.func_180714_a(this.tabName);
            packetBuffer.writeInt(this.channel);
        }

        public static InitTabData readFromPacketBuffer(PacketBuffer packetBuffer) {
            return new InitTabData(packetBuffer.func_150789_c(Short.MAX_VALUE), packetBuffer.readInt());
        }
    }
}

