/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;
import org.cyclops.integratedterminals.part.PartTypeTerminalCraftingJob;

public class ContainerTerminalCraftingJobs
extends ContainerMultipart<PartTypeTerminalCraftingJob, PartStateEmpty<PartTypeTerminalCraftingJob>> {
    private final LazyOptional<INetwork> network = this.getTarget().map(t -> NetworkHelpers.getNetwork((PartPos)t.getCenter())).orElse(LazyOptional.empty());
    private final int valueIdCraftingJobs;
    private long lastUpdate = 0L;
    private List<HandlerWrappedTerminalCraftingPlan> craftingJobs = Lists.newArrayList();

    public ContainerTerminalCraftingJobs(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, PartHelpers.readPartTarget((PacketBuffer)packetBuffer), Optional.empty(), (PartTypeTerminalCraftingJob)PartHelpers.readPart((PacketBuffer)packetBuffer));
    }

    public ContainerTerminalCraftingJobs(int id, PlayerInventory playerInventory, PartTarget target, Optional<IPartContainer> partContainer, PartTypeTerminalCraftingJob partType) {
        super(RegistryEntries.CONTAINER_PART_TERMINAL_CRAFTING_JOBS, id, playerInventory, (IInventory)new Inventory(new ItemStack[0]), Optional.of(target), partContainer, (IPartType)partType);
        this.valueIdCraftingJobs = this.getNextValueId();
    }

    public LazyOptional<INetwork> getNetwork() {
        return this.network;
    }

    public int getChannel() {
        return -1;
    }

    public int getValueIdCraftingJobs() {
        return this.valueIdCraftingJobs;
    }

    public List<HandlerWrappedTerminalCraftingPlan> getCraftingJobs() {
        return this.craftingJobs;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.getWorld().func_201670_d() && this.lastUpdate < System.currentTimeMillis()) {
            this.getNetwork().ifPresent(network -> {
                this.lastUpdate = System.currentTimeMillis() + (long)GeneralConfig.guiTerminalCraftingJobsUpdateFrequency;
                int channel = this.getChannel();
                this.craftingJobs = Lists.newArrayList();
                for (ITerminalStorageTabIngredientCraftingHandler iTerminalStorageTabIngredientCraftingHandler : TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandlers()) {
                    for (ITerminalCraftingPlan craftingJob : iTerminalStorageTabIngredientCraftingHandler.getCraftingJobs((INetwork)network, channel)) {
                        this.craftingJobs.add(new HandlerWrappedTerminalCraftingPlan(iTerminalStorageTabIngredientCraftingHandler, craftingJob));
                    }
                }
                ListNBT tagList = new ListNBT();
                for (HandlerWrappedTerminalCraftingPlan craftingJob : this.craftingJobs) {
                    tagList.add((Object)HandlerWrappedTerminalCraftingPlan.serialize(craftingJob));
                }
                CompoundNBT compoundNBT = new CompoundNBT();
                compoundNBT.func_218657_a("craftingJobs", (INBT)tagList);
                this.setValue(this.valueIdCraftingJobs, compoundNBT);
            });
        }
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        super.onUpdate(valueId, value);
        if (valueId == this.valueIdCraftingJobs) {
            ListNBT tagList = value.func_150295_c("craftingJobs", 10);
            this.craftingJobs = Lists.newArrayListWithExpectedSize((int)tagList.size());
            for (int i = 0; i < tagList.size(); ++i) {
                this.craftingJobs.add(HandlerWrappedTerminalCraftingPlan.deserialize(tagList.func_150305_b(i)));
            }
        }
    }
}

