/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.crafting;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class HandlerWrappedTerminalCraftingPlan {
    private final ITerminalStorageTabIngredientCraftingHandler handler;
    private final ITerminalCraftingPlan craftingPlan;

    public HandlerWrappedTerminalCraftingPlan(ITerminalStorageTabIngredientCraftingHandler handler, ITerminalCraftingPlan craftingPlan) {
        this.handler = handler;
        this.craftingPlan = craftingPlan;
    }

    public ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return this.handler;
    }

    public ITerminalCraftingPlan getCraftingPlan() {
        return this.craftingPlan;
    }

    public static CompoundNBT serialize(HandlerWrappedTerminalCraftingPlan craftingPlan) {
        ITerminalStorageTabIngredientCraftingHandler handler = craftingPlan.getHandler();
        CompoundNBT tag = handler.serializeCraftingPlan(craftingPlan.getCraftingPlan());
        tag.func_74778_a("craftingPlanHandler", handler.getId().toString());
        return tag;
    }

    public static HandlerWrappedTerminalCraftingPlan deserialize(CompoundNBT tag) {
        if (!tag.func_150297_b("craftingPlanHandler", 8)) {
            throw new IllegalArgumentException("Could not find a craftingPlanHandler entry in the given tag");
        }
        String handlerId = tag.func_74779_i("craftingPlanHandler");
        ITerminalStorageTabIngredientCraftingHandler handler = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(new ResourceLocation(handlerId));
        ITerminalCraftingPlan craftingPlan = handler.deserializeCraftingPlan(tag);
        return new HandlerWrappedTerminalCraftingPlan(handler, craftingPlan);
    }
}

