/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.ingredient;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integratedterminals.api.ingredient.IIngredientInstanceSorter;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.terminalstorage.query.SearchMode;

public interface IIngredientComponentTerminalStorageHandler<T, M> {
    public IngredientComponent<T, M> getComponent();

    public ItemStack getIcon();

    @OnlyIn(value=Dist.CLIENT)
    public void drawInstance(MatrixStack var1, T var2, long var3, @Nullable String var5, ContainerScreen var6, ContainerScreenTerminalStorage.DrawLayer var7, float var8, int var9, int var10, int var11, int var12, @Nullable List<ITextComponent> var13);

    default public void addQuantityTooltip(List<ITextComponent> lines, T instance) {
        IFormattableTextComponent line = new TranslationTextComponent("gui.integratedterminals.terminal_storage.tooltip.quantity", new Object[]{this.formatQuantity(instance)}).func_240699_a_(TextFormatting.DARK_GRAY);
        if (lines.size() <= 1) {
            lines.add((ITextComponent)line);
        } else {
            lines.add(1, (ITextComponent)line);
        }
    }

    public String formatQuantity(T var1);

    public boolean isInstance(ItemStack var1);

    public T getInstance(ItemStack var1);

    public long getMaxQuantity(ItemStack var1);

    public int getInitialInstanceMovementQuantity();

    public int getIncrementalInstanceMovementQuantity();

    public int throwIntoWorld(IIngredientComponentStorage<T, M> var1, T var2, PlayerEntity var3);

    default public void insertMaxIntoContainer(IIngredientComponentStorage<T, M> storage, Container container, int containerSlotStart, int containerSlotEnd, T instance) {
        IIngredientMatcher matcher = storage.getComponent().getMatcher();
        Object toAdd = instance;
        int slot = containerSlotStart;
        while (!matcher.isEmpty(toAdd) && slot < containerSlotEnd) {
            T moved;
            if (matcher.isEmpty(moved = this.insertIntoContainer(storage, container, slot++, toAdd, null, true))) continue;
            toAdd = matcher.withQuantity(toAdd, Math.max(0L, matcher.getQuantity(toAdd) - matcher.getQuantity(moved)));
        }
    }

    public T insertIntoContainer(IIngredientComponentStorage<T, M> var1, Container var2, int var3, T var4, @Nullable PlayerEntity var5, boolean var6);

    public void extractActiveStackFromPlayerInventory(IIngredientComponentStorage<T, M> var1, PlayerInventory var2, long var3);

    public void extractMaxFromContainerSlot(IIngredientComponentStorage<T, M> var1, Container var2, int var3, PlayerInventory var4, int var5);

    public long getActivePlayerStackQuantity(PlayerInventory var1);

    public void drainActivePlayerStackQuantity(PlayerInventory var1, long var2);

    @OnlyIn(value=Dist.CLIENT)
    public Predicate<T> getInstanceFilterPredicate(SearchMode var1, String var2);

    public Collection<IIngredientInstanceSorter<T>> getInstanceSorters();
}

