/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt.network.serverbound;

import me.tepis.integratednbt.NBTExtractorTileEntity;
import me.tepis.integratednbt.network.Message;
import me.tepis.integratednbt.network.MessageHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class NBTExtractorUpdateServerMessageBase
implements Message {
    protected BlockPos blockPos;

    public NBTExtractorUpdateServerMessageBase(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public NBTExtractorUpdateServerMessageBase() {
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.blockPos = BlockPos.func_218283_e((long)buf.readLong());
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.blockPos.func_218275_a());
    }

    public static abstract class NBTExtractorUpdateServerMessageHandlerBase<T extends NBTExtractorUpdateServerMessageBase>
    extends MessageHandler<T> {
        @Override
        public final void onMessage(T message, NetworkEvent.Context ctx) {
            ctx.enqueueWork(() -> {
                ServerPlayerEntity player = ctx.getSender();
                assert (player != null);
                World world = player.field_70170_p;
                if (!world.func_175667_e(message.blockPos)) {
                    return;
                }
                TileEntity tileEntity = world.func_175625_s(message.blockPos);
                if (tileEntity == null) {
                    return;
                }
                if (!(tileEntity instanceof NBTExtractorTileEntity)) {
                    return;
                }
                NBTExtractorTileEntity nbtExtractorTileEntity = (NBTExtractorTileEntity)tileEntity;
                if (!nbtExtractorTileEntity.func_70300_a((PlayerEntity)player)) {
                    return;
                }
                this.updateTileEntity(message, nbtExtractorTileEntity);
            });
        }

        public abstract void updateTileEntity(T var1, NBTExtractorTileEntity var2);
    }
}

