/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt.network.serverbound;

import me.tepis.integratednbt.NBTExtractorOutputMode;
import me.tepis.integratednbt.NBTExtractorTileEntity;
import me.tepis.integratednbt.network.serverbound.NBTExtractorUpdateServerMessageBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class NBTExtractorUpdateOutputModeMessage
extends NBTExtractorUpdateServerMessageBase {
    private NBTExtractorOutputMode outputMode;

    private NBTExtractorUpdateOutputModeMessage() {
    }

    public NBTExtractorUpdateOutputModeMessage(BlockPos blockPos, NBTExtractorOutputMode outputMode) {
        super(blockPos);
        this.outputMode = outputMode;
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        super.fromBytes(buf);
        this.outputMode = NBTExtractorOutputMode.values()[buf.readByte()];
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeByte(this.outputMode.ordinal());
    }

    public static class NBTExtractorUpdateOutputModeMessageHandler
    extends NBTExtractorUpdateServerMessageBase.NBTExtractorUpdateServerMessageHandlerBase<NBTExtractorUpdateOutputModeMessage> {
        @Override
        public void updateTileEntity(NBTExtractorUpdateOutputModeMessage message, NBTExtractorTileEntity nbtExtractorTileEntity) {
            nbtExtractorTileEntity.setOutputMode(message.outputMode);
        }

        @Override
        protected Class<NBTExtractorUpdateOutputModeMessage> getMessageClass() {
            return NBTExtractorUpdateOutputModeMessage.class;
        }

        @Override
        protected NBTExtractorUpdateOutputModeMessage createEmpty() {
            return new NBTExtractorUpdateOutputModeMessage();
        }
    }
}

