/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public abstract class NBTValueConverter {
    public static IValueType<? extends IValue> mapNBTToValueType(INBT nbt) {
        return NBTValueConverter.mapNBTIDToValueType(nbt.func_74732_a());
    }

    public static IValueType<?> mapNBTIDToValueType(int nbtId) {
        switch (nbtId) {
            case 1: 
            case 2: 
            case 3: {
                return ValueTypes.INTEGER;
            }
            case 4: {
                return ValueTypes.LONG;
            }
            case 5: 
            case 6: {
                return ValueTypes.DOUBLE;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                return ValueTypes.LIST;
            }
            case 8: {
                return ValueTypes.STRING;
            }
            case 10: {
                return ValueTypes.NBT;
            }
        }
        throw new RuntimeException("Unexpected NBT id:" + nbtId);
    }

    public static String getDefaultValueDisplayText(int nbtId) {
        String formatCode = NBTValueConverter.getDefaultValue(nbtId).getType().getDisplayColorFormat().toString();
        switch (nbtId) {
            default: {
                return formatCode + "0";
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                return formatCode + "[]";
            }
            case 8: {
                return formatCode + "\"\"";
            }
            case 10: 
        }
        return formatCode + "{}";
    }

    public static IValue getDefaultValue(int nbtId) {
        switch (nbtId) {
            case 1: 
            case 2: 
            case 3: {
                return ValueTypeInteger.ValueInteger.of((int)0);
            }
            case 4: {
                return ValueTypeLong.ValueLong.of((long)0L);
            }
            case 5: 
            case 6: {
                return ValueTypeDouble.ValueDouble.of((double)0.0);
            }
            case 7: 
            case 11: 
            case 12: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, new ArrayList());
            }
            case 8: {
                return ValueTypeString.ValueString.of((String)"");
            }
            case 9: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.CATEGORY_ANY, new ArrayList());
            }
        }
        return ValueTypeNbt.ValueNbt.of((INBT)new CompoundNBT());
    }

    public static IValue mapNBTToValue(INBT nbt) {
        switch (nbt.func_74732_a()) {
            case 1: {
                return ValueTypeInteger.ValueInteger.of((int)((ByteNBT)nbt).func_150287_d());
            }
            case 2: {
                return ValueTypeInteger.ValueInteger.of((int)((ShortNBT)nbt).func_150287_d());
            }
            case 3: {
                return ValueTypeInteger.ValueInteger.of((int)((IntNBT)nbt).func_150287_d());
            }
            case 4: {
                return ValueTypeLong.ValueLong.of((long)((LongNBT)nbt).func_150291_c());
            }
            case 5: {
                return ValueTypeDouble.ValueDouble.of((double)((FloatNBT)nbt).func_150286_g());
            }
            case 6: {
                return ValueTypeDouble.ValueDouble.of((double)((DoubleNBT)nbt).func_150286_g());
            }
            case 7: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, Arrays.stream(ArrayUtils.toObject((byte[])((ByteArrayNBT)nbt).func_150292_c())).map(ValueTypeInteger.ValueInteger::of).collect(Collectors.toList()));
            }
            case 8: {
                return ValueTypeString.ValueString.of((String)nbt.func_150285_a_());
            }
            case 9: {
                return ValueTypeList.ValueList.ofAll((IValue[])((IValue[])((ListNBT)nbt).stream().map(NBTValueConverter::mapNBTToValue).toArray(IValue[]::new)));
            }
            case 10: {
                return ValueTypeNbt.ValueNbt.of((INBT)nbt);
            }
            case 11: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.INTEGER, Arrays.stream(ArrayUtils.toObject((int[])((IntArrayNBT)nbt).func_150302_c())).map(ValueTypeInteger.ValueInteger::of).collect(Collectors.toList()));
            }
            case 12: {
                return ValueTypeList.ValueList.ofList((IValueType)ValueTypes.LONG, Arrays.stream(ArrayUtils.toObject((long[])((LongArrayNBT)nbt).func_197652_h())).map(ValueTypeLong.ValueLong::of).collect(Collectors.toList()));
            }
        }
        return null;
    }
}

