/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.tepis.integratednbt.IntegratedNBT;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.apache.commons.lang3.StringUtils;

public class NBTPath {
    private static final int MAX_EXTRACTION_DEPTH = 128;
    private static final String KEY_PATH = "path";
    private static final String KEY_TYPE = "type";
    private static final String TYPE_KEY = "key";
    private static final String KEY_KEY = "key";
    private static final String TYPE_INDEX = "index";
    private static final String KEY_INDEX = "index";
    private final ArrayList<Segment> segments;

    public NBTPath(ArrayList<Segment> segments) {
        this.segments = segments;
    }

    public NBTPath() {
        this.segments = new ArrayList();
    }

    public static Optional<NBTPath> fromNBT(INBT nbt) {
        try {
            if (nbt instanceof CompoundNBT) {
                nbt = ((CompoundNBT)nbt).func_74781_a(KEY_PATH);
            }
            NBTPath.myAssert(nbt instanceof ListNBT);
            ListNBT list = (ListNBT)nbt;
            NBTPath.myAssert(list.func_230528_d__() == 10 || list.size() == 0);
            NBTPath.myAssert(list.size() <= 128);
            ArrayList<Segment> segments = new ArrayList<Segment>(list.size());
            for (INBT item : list) {
                CompoundNBT compound = (CompoundNBT)item;
                String type = compound.func_74779_i(KEY_TYPE);
                NBTPath.myAssert(!type.isEmpty());
                if (type.equals("key")) {
                    NBTPath.myAssert(compound.func_74764_b("key"));
                    String key = compound.func_74779_i("key");
                    NBTPath.myAssert(!key.isEmpty());
                    segments.add(new KeySegment(key));
                    continue;
                }
                NBTPath.myAssert(type.equals("index"));
                NBTPath.myAssert(compound.func_74764_b("index"));
                int index = compound.func_74762_e("index");
                NBTPath.myAssert(index >= 0);
                segments.add(new IndexSegment(index));
            }
            return Optional.of(new NBTPath(segments));
        }
        catch (Exception ex) {
            IntegratedNBT.LOGGER.error("Failed to decode NBT for ExtractionPath.", (Throwable)ex);
            return Optional.empty();
        }
    }

    private static void myAssert(boolean value) {
        if (!value) {
            throw new RuntimeException("Assertion failed. D:");
        }
    }

    public void pushKey(String key) {
        this.segments.add(new KeySegment(key));
    }

    public void pushIndex(int index) {
        this.segments.add(new IndexSegment(index));
    }

    public void pop() {
        this.segments.remove(this.segments.size() - 1);
    }

    public NBTPath copy() {
        return new NBTPath((ArrayList)this.segments.clone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBTPath that = (NBTPath)o;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public CompoundNBT toNBTCompound() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(KEY_PATH, (INBT)this.toNBT());
        return compound;
    }

    public ListNBT toNBT() {
        ListNBT list = new ListNBT();
        for (Segment segment : this.segments) {
            CompoundNBT tag;
            if (segment instanceof KeySegment) {
                tag = new CompoundNBT();
                tag.func_74778_a(KEY_TYPE, "key");
                tag.func_74778_a("key", ((KeySegment)segment).key);
                list.add((Object)tag);
                continue;
            }
            tag = new CompoundNBT();
            tag.func_74778_a(KEY_TYPE, "index");
            tag.func_74768_a("index", ((IndexSegment)segment).index);
            list.add((Object)tag);
        }
        return list;
    }

    public INBT extract(INBT source) {
        for (Segment segment : this.segments) {
            if (source == null) {
                return null;
            }
            source = segment.access(source);
        }
        return source;
    }

    public String getDisplayText() {
        if (this.segments.isEmpty()) {
            return I18n.func_135052_a((String)"integratednbt:nbt_extractor.root", (Object[])new Object[0]);
        }
        String arrow = I18n.func_135052_a((String)"integratednbt:nbt_extractor.arrow", (Object[])new Object[0]);
        return I18n.func_135052_a((String)"integratednbt:nbt_extractor.root", (Object[])new Object[0]) + arrow + this.segments.stream().map(Segment::getDisplayText).collect(Collectors.joining(arrow));
    }

    public String getCompactDisplayText() {
        if (this.segments.isEmpty()) {
            return "id";
        }
        return this.segments.stream().map(Segment::getCompactDisplayText).collect(Collectors.joining());
    }

    public int getDepth() {
        return this.segments.size();
    }

    public String getCyclopsNBTPath() {
        StringBuilder stringBuilder = new StringBuilder().append('$');
        for (Segment segment : this.segments) {
            segment.buildCyclopsNBTPath(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static class IndexSegment
    implements Segment {
        private final int index;

        private IndexSegment(int index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexSegment that = (IndexSegment)o;
            return this.index == that.index;
        }

        public int hashCode() {
            return this.index;
        }

        @Override
        public String getDisplayText() {
            return I18n.func_135052_a((String)"integratednbt:nbt_extractor.index", (Object[])new Object[]{String.valueOf(this.index)});
        }

        @Override
        public String getCompactDisplayText() {
            return "[" + this.index + "]";
        }

        @Override
        public INBT access(INBT parent) {
            if (parent instanceof ListNBT) {
                ListNBT parentList = (ListNBT)parent;
                if (parentList.size() <= this.index || this.index < 0) {
                    return null;
                }
                INBT base = parentList.get(this.index);
                if (base.func_74732_a() == 0) {
                    return null;
                }
                return base;
            }
            return null;
        }

        @Override
        public void buildCyclopsNBTPath(StringBuilder stringBuilder) {
            stringBuilder.append("[").append(this.index).append("]");
        }
    }

    private static class KeySegment
    implements Segment {
        private final String key;
        private static final Pattern NON_SPECIAL = Pattern.compile("^[a-zA-Z_0-9]+$");

        public KeySegment(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeySegment that = (KeySegment)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public String getDisplayText() {
            return this.key;
        }

        @Override
        public String getCompactDisplayText() {
            return "." + this.key;
        }

        @Override
        public INBT access(INBT parent) {
            if (parent instanceof CompoundNBT) {
                return ((CompoundNBT)parent).func_74781_a(this.key);
            }
            return null;
        }

        @Override
        public void buildCyclopsNBTPath(StringBuilder stringBuilder) {
            if (NON_SPECIAL.matcher(this.key).matches() && !this.key.equals("length")) {
                stringBuilder.append('.').append(this.key);
            } else {
                stringBuilder.append("[\"").append(StringUtils.replace((String)StringUtils.replace((String)this.key, (String)"\\", (String)"\\\\"), (String)"\"", (String)"\\\"")).append("\"]");
            }
        }
    }

    private static interface Segment {
        public String getDisplayText();

        public String getCompactDisplayText();

        public INBT access(INBT var1);

        public void buildCyclopsNBTPath(StringBuilder var1);
    }
}

