/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.tepis.integratednbt.NBTExtractedVariableFacade;
import me.tepis.integratednbt.NBTExtractedVariableFacadeHandler;
import me.tepis.integratednbt.NBTExtractionOperator;
import me.tepis.integratednbt.NBTPath;
import me.tepis.integratednbt.NBTValueConverter;
import me.tepis.integratednbt.Texture;
import me.tepis.integratednbt.TexturePart;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;

public enum NBTExtractorOutputMode {
    REFERENCE("reference", TextFormatting.YELLOW, Nest.access$000().createPart(90, 0, 12, 12), Nest.access$000().createPart(90, 12, 12, 12)){

        @Override
        public ItemStack writeItemStack(Supplier<IVariableFacade> sourceVariableFacadeSupplier, ItemStack outputVariableItemStack, INBT currentNBT, final NBTPath extractionPath, final byte defaultNBTId, BlockState blockState) {
            IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
            IVariableFacade variableFacade = sourceVariableFacadeSupplier.get();
            if (variableFacade != null) {
                final int sourceNBTId = variableFacade.getId();
                IVariableFacadeHandlerRegistry.IVariableFacadeFactory<NBTExtractedVariableFacade> factory = new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<NBTExtractedVariableFacade>(){

                    public NBTExtractedVariableFacade create(boolean generateId) {
                        return new NBTExtractedVariableFacade(generateId, sourceNBTId, extractionPath, defaultNBTId);
                    }

                    public NBTExtractedVariableFacade create(int id) {
                        return new NBTExtractedVariableFacade(id, sourceNBTId, extractionPath, defaultNBTId);
                    }
                };
                return registry.writeVariableFacadeItem(true, outputVariableItemStack, (IVariableFacadeHandler)NBTExtractedVariableFacadeHandler.getInstance(), (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)factory, null, blockState);
            }
            return null;
        }
    }
    ,
    OPERATOR("operator", TextFormatting.DARK_GREEN, Nest.access$000().createPart(102, 0, 12, 12), Nest.access$000().createPart(102, 12, 12, 12)){

        @Override
        public ItemStack writeItemStack(Supplier<IVariableFacade> sourceVariableFacadeSupplier, ItemStack outputVariableItemStack, INBT currentNBT, NBTPath extractionPath, byte defaultNBTId, BlockState blockState) {
            return NBTExtractorOutputMode.getVariableUsingValue((IValue)ValueTypeOperator.ValueOperator.of((IOperator)new NBTExtractionOperator(extractionPath, defaultNBTId)), outputVariableItemStack, blockState);
        }
    }
    ,
    VALUE("value", TextFormatting.GOLD, Nest.access$000().createPart(114, 0, 12, 12), Nest.access$000().createPart(114, 12, 12, 12)){

        @Override
        public ItemStack writeItemStack(Supplier<IVariableFacade> sourceVariableFacadeSupplier, ItemStack outputVariableItemStack, INBT currentNBT, NBTPath extractionPath, byte defaultNBTId, BlockState blockState) {
            sourceVariableFacadeSupplier.get();
            INBT extractedNBT = extractionPath.extract(currentNBT);
            IValue value = extractedNBT == null ? NBTValueConverter.getDefaultValue(defaultNBTId) : NBTValueConverter.mapNBTToValue(extractedNBT);
            return NBTExtractorOutputMode.getVariableUsingValue(value, outputVariableItemStack, blockState);
        }
    }
    ,
    NBT_PATH("nbt_path", TextFormatting.RED, Nest.access$000().createPart(150, 0, 12, 12), Nest.access$000().createPart(150, 12, 12, 12)){

        @Override
        public ItemStack writeItemStack(Supplier<IVariableFacade> sourceVariableFacadeSupplier, ItemStack outputVariableItemStack, INBT currentNBT, NBTPath extractionPath, byte defaultNBTId, BlockState blockState) {
            return NBTExtractorOutputMode.getVariableUsingValue((IValue)ValueTypeString.ValueString.of((String)extractionPath.getCyclopsNBTPath()), outputVariableItemStack, blockState);
        }
    };

    private String translationId;
    private TextFormatting color;
    private TexturePart buttonTextureNormal;
    private TexturePart buttonTextureHover;

    private NBTExtractorOutputMode(String translationId, TextFormatting color, TexturePart buttonTextureNormal, TexturePart buttonTextureHover) {
        this.translationId = translationId;
        this.color = color;
        this.buttonTextureNormal = buttonTextureNormal;
        this.buttonTextureHover = buttonTextureHover;
    }

    @Nullable
    private static ItemStack getVariableUsingValue(final IValue value, ItemStack outputVariableItemStack, BlockState blockState) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        if (value == null) {
            return null;
        }
        return registry.writeVariableFacadeItem(true, outputVariableItemStack, (IVariableFacadeHandler)ValueTypes.REGISTRY, (IVariableFacadeHandlerRegistry.IVariableFacadeFactory)new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade>(){

            public IValueTypeVariableFacade create(boolean generateId) {
                return new ValueTypeVariableFacade(generateId, value.getType(), value);
            }

            public IValueTypeVariableFacade create(int id) {
                return new ValueTypeVariableFacade(id, value.getType(), value);
            }
        }, null, blockState);
    }

    public TexturePart getButtonTextureNormal() {
        return this.buttonTextureNormal;
    }

    public TexturePart getButtonTextureHover() {
        return this.buttonTextureHover;
    }

    public abstract ItemStack writeItemStack(Supplier<IVariableFacade> var1, ItemStack var2, INBT var3, NBTPath var4, byte var5, BlockState var6);

    public ITextComponent getDescription(boolean highlighted) {
        return new TranslationTextComponent("integratednbt:nbt_extractor.output_mode." + this.translationId + ".description", new Object[]{this.getName()}).func_230530_a_(highlighted ? Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY) : Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GRAY));
    }

    public ITextComponent getName() {
        return new TranslationTextComponent("integratednbt:nbt_extractor.output_mode." + this.translationId + ".name").func_230530_a_(Style.field_240709_b_.func_240712_a_(this.color));
    }

    private static class Nest {
        private static final Texture GUI_TEXTURE = new Texture("integratednbt", "textures/gui/nbt_extractor.png");
        private static final int BUTTON_SIZE = 12;

        private Nest() {
        }

        static /* synthetic */ Texture access$000() {
            return GUI_TEXTURE;
        }
    }
}

