/*
 * Decompiled with CFR 0.152.
 */
package me.tepis.integratednbt;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tepis.integratednbt.Additions;
import me.tepis.integratednbt.CabledHorizontalBlock;
import me.tepis.integratednbt.ItemGroups;
import me.tepis.integratednbt.NBTExtractorTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;

public class NBTExtractor
extends CabledHorizontalBlock {
    public static final String REGISTRY_NAME = "nbt_extractor";

    public NBTExtractor(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    @Override
    public void func_196243_a(BlockState oldState, @Nonnull World worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (oldState.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof NBTExtractorTileEntity) {
            NBTExtractorTileEntity inventory = (NBTExtractorTileEntity)tileEntity;
            for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inventory.func_70301_a(slot));
            }
        }
        super.func_196243_a(oldState, worldIn, pos, newState, isMoving);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new NBTExtractorTileEntity();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
            if (WrenchHelpers.isWrench((PlayerEntity)player, (ItemStack)heldItem, (World)world, (BlockPos)blockPos, (Direction)rayTraceResult.func_216354_b()) && player.func_213453_ef()) {
                Block.func_220054_a((BlockState)blockState, (World)world, (BlockPos)blockPos, (TileEntity)(blockState.hasTileEntity() ? world.func_175625_s(blockPos) : null), (Entity)player, (ItemStack)heldItem);
                world.func_175655_b(blockPos, false);
                return ActionResultType.SUCCESS;
            }
            if (heldItem.func_77973_b() == Additions.NBT_EXTRACTOR_REMOTE.get()) {
                return ActionResultType.PASS;
            }
            if (!player.func_213453_ef()) {
                this.playerAccess(world, blockPos, playerMP);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void playerAccess(World world, BlockPos pos, ServerPlayerEntity playerMP) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof NBTExtractorTileEntity) {
            NBTExtractorTileEntity nbtExtractorTileEntity = (NBTExtractorTileEntity)tileentity;
            nbtExtractorTileEntity.refreshVariables(true);
            NetworkHooks.openGui((ServerPlayerEntity)playerMP, (INamedContainerProvider)nbtExtractorTileEntity, (BlockPos)pos);
        }
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)field_185512_D)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)field_185512_D)));
    }

    public static class NBTExtractorBlockItem
    extends BlockItem {
        public NBTExtractorBlockItem() {
            super((Block)Additions.NBT_EXTRACTOR_BLOCK.get(), new Item.Properties().func_200916_a(ItemGroups.ITEM_GROUP));
        }

        public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
            super.func_77624_a(itemStack, world, tooltip, flag);
            tooltip.add((ITextComponent)new TranslationTextComponent("integratednbt:nbt_extractor.tooltip"));
        }
    }
}

