/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.world.biome;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.BiomeMaker;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.extendedconfig.BiomeConfig;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.world.gen.TreeMenril;
import org.cyclops.integrateddynamics.world.gen.feature.WorldFeatures;

public class BiomeMeneglinConfig
extends BiomeConfig {
    @ConfigurableProperty(category="biome", comment="The weight of spawning in the overworld, 0 disables spawning.", minimalValue=0)
    public static int spawnWeight = 5;
    @ConfigurableProperty(category="worldgeneration", comment="The chance at which a Menril Tree will spawn in the wild, the higher this value, the lower the chance.", minimalValue=0, requiresMcRestart=true, configLocation=ModConfig.Type.SERVER)
    public static int wildMenrilTreeChance = 100;
    public static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_GENERAL;
    public static ConfiguredFeature<?, ?> CONFIGURED_FEATURE_MENEGLIN;

    public BiomeMeneglinConfig() {
        super((ModBase)IntegratedDynamics._instance, "meneglin", eConfig -> {
            BiomeGenerationSettings.Builder generationBuilder = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
            DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationBuilder);
            generationBuilder.func_242516_a(StructureFeatures.field_244159_y);
            DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationBuilder);
            DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)generationBuilder);
            DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generationBuilder);
            DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generationBuilder);
            DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generationBuilder);
            DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generationBuilder);
            generationBuilder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, WorldFeatures.TREES_MENEGLIN);
            generationBuilder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, WorldFeatures.FLOWERS_MENEGLIN);
            DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)generationBuilder);
            DefaultBiomeFeatures.func_243717_aa((BiomeGenerationSettings.Builder)generationBuilder);
            DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generationBuilder);
            DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generationBuilder);
            return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.4f).func_205420_b(0.4f).func_205414_c(0.7f).func_205417_d(0.25f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4445678).func_235248_c_(Helpers.RGBToInt((int)85, (int)168, (int)221)).func_235239_a_(12638463).func_242541_f(Helpers.RGBToInt((int)85, (int)221, (int)168)).func_242540_e(Helpers.RGBToInt((int)128, (int)208, (int)185)).func_242539_d(Helpers.RGBToInt((int)178, (int)238, (int)233)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(BiomeMaker.func_244259_y().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200736_ab, 4, 2, 3)).func_242577_b()).func_242457_a(generationBuilder.func_242508_a()).func_242455_a();
        });
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoadingEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModSetup);
    }

    public void onConfigPropertyReload(ConfigurablePropertyData<?> configProperty, boolean reload) {
        if (!reload && configProperty.getName().equals("meneglin.spawnWeight") && spawnWeight > 0) {
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(this.getRegistryKey(), spawnWeight));
            BiomeDictionary.addTypes((RegistryKey)this.getRegistryKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OVERWORLD});
            BiomeDictionary.addTypes((RegistryKey)this.getRegistryKey(), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST});
        }
    }

    public void onModSetup(FMLCommonSetupEvent event) {
        CONFIGURED_FEATURE_MENEGLIN = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), "tree_menril_meneglin"), (Object)Feature.field_236291_c_.func_225566_b_((IFeatureConfig)TreeMenril.getMenrilTreeConfig()).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.05f, 1))));
        CONFIGURED_FEATURE_GENERAL = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation(this.getMod().getModId(), "tree_menril_general"), (Object)Feature.field_236291_c_.func_225566_b_((IFeatureConfig)TreeMenril.getMenrilTreeConfig()).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 1.0f / (float)wildMenrilTreeChance, 1))));
    }

    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (event.getName().equals((Object)new ResourceLocation("integrateddynamics:meneglin"))) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> CONFIGURED_FEATURE_MENEGLIN);
        } else if (BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)RegistryKey.func_240904_a_((ResourceLocation)this.getRegistry().getRegistryName()), (ResourceLocation)event.getName())).contains(BiomeDictionary.Type.OVERWORLD)) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> CONFIGURED_FEATURE_GENERAL);
        }
    }
}

