/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.NetworkElementBase;
import org.cyclops.integrateddynamics.tileentity.TileEnergyBattery;

public class EnergyBatteryNetworkElement
extends NetworkElementBase {
    private final DimPos pos;

    protected Optional<TileEnergyBattery> getTile() {
        return TileHelpers.getSafeTile((DimPos)this.getPos(), TileEnergyBattery.class);
    }

    @Override
    public int getUpdateInterval() {
        return 0;
    }

    @Override
    public boolean isUpdate() {
        return false;
    }

    @Override
    public void update(INetwork network) {
    }

    @Override
    public void beforeNetworkKill(INetwork network) {
    }

    @Override
    public void afterNetworkAlive(INetwork network) {
    }

    @Override
    public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
    }

    @Override
    public boolean onNetworkAddition(INetwork network) {
        PartPos pos = PartPos.of(this.getPos(), null);
        boolean added = NetworkHelpers.getEnergyNetworkChecked(network).addPosition(pos, 0, 0);
        this.scheduleNetworkObservation(network, pos);
        return added;
    }

    @Override
    public void onNetworkRemoval(INetwork network) {
        PartPos pos = PartPos.of(this.getPos(), null);
        this.scheduleNetworkObservation(network, pos);
        NetworkHelpers.getEnergyNetworkChecked(network).removePosition(pos);
    }

    protected void scheduleNetworkObservation(INetwork network, PartPos pos) {
        NetworkHelpers.getEnergyNetwork(network).ifPresent(energyNetwork -> energyNetwork.scheduleObservationForced(0, pos));
    }

    @Override
    public void onPreRemoved(INetwork network) {
    }

    @Override
    public void onNeighborBlockChange(INetwork network, IBlockReader world, Block neighbourBlock, BlockPos neighbourPos) {
    }

    @Override
    public void setPriorityAndChannel(INetwork network, int priority, int channel) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getChannel() {
        return 0;
    }

    @Override
    public boolean canRevalidate(INetwork network) {
        return this.canRevalidatePositioned(network, this.pos);
    }

    @Override
    public void revalidate(INetwork network) {
        super.revalidate(network);
        this.revalidatePositioned(network, this.pos);
    }

    @Override
    public int compareTo(INetworkElement o) {
        if (o instanceof EnergyBatteryNetworkElement) {
            return this.getPos().compareTo(((EnergyBatteryNetworkElement)o).getPos());
        }
        return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnergyBatteryNetworkElement)) {
            return false;
        }
        EnergyBatteryNetworkElement other = (EnergyBatteryNetworkElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DimPos this$pos = this.getPos();
        DimPos other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnergyBatteryNetworkElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DimPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 0 : $pos.hashCode());
        return result;
    }

    @ConstructorProperties(value={"pos"})
    public EnergyBatteryNetworkElement(DimPos pos) {
        this.pos = pos;
    }

    public DimPos getPos() {
        return this.pos;
    }

    @Override
    public String toString() {
        return "EnergyBatteryNetworkElement(pos=" + this.getPos() + ")";
    }
}

