/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class ItemBlockCable
extends BlockItem {
    private static final List<IUseAction> USE_ACTIONS = Lists.newArrayList();

    public ItemBlockCable(Block block, Item.Properties builder) {
        super(block, builder);
    }

    public static void addUseAction(IUseAction useAction) {
        USE_ACTIONS.add(useAction);
    }

    protected boolean checkCableAt(World world, BlockPos pos, @Nullable Direction side) {
        if (!CableHelpers.isNoFakeCable((IBlockReader)world, pos, side) && CableHelpers.getCable((IBlockReader)world, pos, side) != null) {
            return true;
        }
        for (IUseAction useAction : USE_ACTIONS) {
            if (!useAction.canPlaceAt(world, pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean func_195944_a(BlockItemUseContext context, BlockState blockState) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        BlockPos target = pos.func_177972_a(side);
        if (this.checkCableAt(world, pos, side)) {
            return true;
        }
        if (this.checkCableAt(world, target, side.func_176734_d())) {
            return true;
        }
        return !this.func_219987_d() || blockState.func_196955_c((IWorldReader)context.func_195991_k(), target);
    }

    protected boolean attempItemUseTarget(ItemUseContext context, BlockPos pos, Direction side, BlockCable blockCable, boolean offsetAdded) {
        BlockState blockState = context.func_195991_k().func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!block.isAir(blockState, (IBlockReader)context.func_195991_k(), pos)) {
            ICableFakeable cable = (ICableFakeable)CableHelpers.getCableFakeable((IBlockReader)context.func_195991_k(), pos, side).orElse(null);
            if (cable != null && !cable.isRealCable()) {
                if (!context.func_195991_k().func_201670_d()) {
                    cable.setRealCable(true);
                    CableHelpers.updateConnections((IBlockReader)context.func_195991_k(), pos, side);
                    CableHelpers.onCableAdded(context.func_195991_k(), pos);
                    CableHelpers.onCableAddedByPlayer(context.func_195991_k(), pos, (LivingEntity)context.func_195999_j());
                }
                return true;
            }
            if (!offsetAdded) {
                for (IUseAction useAction : USE_ACTIONS) {
                    if (!useAction.attempItemUseTarget(context.func_195996_i(), context.func_195991_k(), pos, blockCable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void afterItemUse(ItemUseContext context, BlockPos pos, BlockCable blockCable, boolean calledSuper) {
        if (!calledSuper) {
            ItemBlockCable.playPlaceSound(context.func_195991_k(), pos);
            context.func_195996_i().func_190918_g(1);
        }
        blockCable.setDisableCollisionBox(false);
    }

    public static void playPlaceSound(World world, BlockPos pos) {
        BlockCable block = RegistryEntries.BLOCK_CABLE;
        SoundType soundType = block.func_220072_p(block.func_176223_P());
        world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
    }

    public static void playBreakSound(World world, BlockPos pos, BlockState blockState) {
        world.func_175669_a(2001, pos, Block.func_196246_j((BlockState)blockState));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        BlockCable blockCable = (BlockCable)this.func_179223_d();
        blockCable.setDisableCollisionBox(true);
        if (this.attempItemUseTarget(context, context.func_195995_a(), context.func_196000_l(), blockCable, false)) {
            this.afterItemUse(context, context.func_195995_a(), blockCable, false);
            return ActionResultType.SUCCESS;
        }
        BlockPos posOffset = context.func_195995_a().func_177972_a(context.func_196000_l());
        if (this.attempItemUseTarget(context, posOffset, context.func_196000_l().func_176734_d(), blockCable, true)) {
            this.afterItemUse(context, posOffset, blockCable, false);
            return ActionResultType.SUCCESS;
        }
        ActionResultType ret = super.func_195939_a(context);
        this.afterItemUse(context, context.func_195995_a(), blockCable, true);
        return ret;
    }

    public static interface IUseAction {
        public boolean attempItemUseTarget(ItemStack var1, World var2, BlockPos var3, BlockCable var4);

        public boolean canPlaceAt(World var1, BlockPos var2);
    }
}

