/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.item.AspectVariableFacade;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class AspectAppendix
extends SectionAppendix {
    private static final int SLOT_SIZE = 16;
    private final IAspect aspect;
    private ItemStack itemStack;

    public AspectAppendix(IInfoBook infoBook, IAspect aspect) {
        super(infoBook);
        this.aspect = aspect;
    }

    protected int getOffsetY() {
        return 5;
    }

    protected int getWidth() {
        return 100;
    }

    protected int getHeight() {
        return 30 + (this.aspect.hasProperties() ? 10 * (this.aspect.getPropertyTypes().size() + 1) : 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void drawElement(ScreenInfoBook gui, MatrixStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = 5;
        gui.drawOuterBorder(matrixStack, x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(matrixStack, x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(matrixStack, L10NHelpers.localize((String)"aspect.integrateddynamics.name", (Object[])new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, Helpers.RGBToInt((int)120, (int)20, (int)30));
        RenderHelper.func_227780_a_();
        Minecraft.func_71410_x().func_175599_af().func_180450_b(this.itemStack, x, y);
        String aspectName = L10NHelpers.localize((String)this.aspect.getTranslationKey(), (Object[])new Object[0]);
        String valueTypeName = L10NHelpers.localize((String)this.aspect.getValueType().getTranslationKey(), (Object[])new Object[0]);
        gui.drawScaledCenteredString(matrixStack, L10NHelpers.localize((String)aspectName, (Object[])new Object[0]), x + 10, y + 8, width, 1.0f, gui.getBannerWidth() - 10, 0);
        String valueString = L10NHelpers.localize((String)(this.aspect.getValueType().getDisplayColorFormat() + valueTypeName), (Object[])new Object[0]);
        gui.getFontRenderer().func_238421_b_(matrixStack, L10NHelpers.localize((String)(this.aspect instanceof IAspectWrite ? "gui.integrateddynamics.input" : "gui.integrateddynamics.output"), (Object[])new Object[]{valueString}), (float)x, (float)(y + 16), 0);
        if (this.aspect.hasProperties()) {
            int offsetY = 26;
            gui.getFontRenderer().func_238421_b_(matrixStack, TextFormatting.DARK_GRAY + L10NHelpers.localize((String)"gui.integrateddynamics.part.properties", (Object[])new Object[0]), (float)x, (float)(y + offsetY), 0);
            for (IAspectPropertyTypeInstance property : this.aspect.getPropertyTypes()) {
                gui.getFontRenderer().func_238421_b_(matrixStack, TextFormatting.DARK_GRAY + L10NHelpers.localize((String)property.getTranslationKey(), (Object[])new Object[0]), (float)(x + 10), (float)(y + (offsetY += 10)), 0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void postDrawElement(ScreenInfoBook gui, MatrixStack matrixStack, int x, int y, int width, int height, int page, int mx, int my) {
        GlStateManager.func_227626_N_();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16) {
            ArrayList lines = Lists.newArrayList();
            this.aspect.loadTooltip(lines, true);
            gui.func_243308_b(matrixStack, (List)lines, mx, my);
        }
        GlStateManager.func_227627_O_();
        GlStateManager.func_227722_g_();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)770, (int)771);
    }

    public void preBakeElement(InfoSection infoSection) {
    }

    public void bakeElement(InfoSection infoSection) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        this.itemStack = registry.writeVariableFacadeItem(new ItemStack((IItemProvider)RegistryEntries.ITEM_VARIABLE), new AspectVariableFacade(false, 0, this.aspect), Aspects.REGISTRY);
    }
}

