/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageMutable;

public class RecipeEnergyContainerCombination
extends SpecialRecipe {
    private final Ingredient batteryItem;
    private final int maxCapacity;

    public RecipeEnergyContainerCombination(ResourceLocation id, Ingredient batteryItem, int maxCapacity) {
        super(id);
        this.batteryItem = batteryItem;
        this.maxCapacity = maxCapacity;
    }

    public Ingredient getBatteryItem() {
        return this.batteryItem;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingInventory grid, World world) {
        return !this.getCraftingResult(grid).func_190926_b();
    }

    public ItemStack func_77571_b() {
        return this.batteryItem.func_193365_a()[0];
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inventory) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inventory.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RegistryEntries.RECIPESERIALIZER_ENERGY_CONTAINER_COMBINATION;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack output = this.func_77571_b().func_77946_l();
        IEnergyStorageCapacity energyStorage = (IEnergyStorageCapacity)output.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        int totalCapacity = 0;
        int totalEnergy = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.func_70302_i_(); ++j) {
            ItemStack element = grid.func_70301_a(j).func_77946_l().func_77979_a(1);
            if (element.func_190926_b()) continue;
            if (this.batteryItem.test(element)) {
                IEnergyStorageCapacity currentEnergyStorage = (IEnergyStorageCapacity)element.getCapability(CapabilityEnergy.ENERGY).orElse(null);
                ++inputItems;
                totalEnergy = Helpers.addSafe((int)totalEnergy, (int)currentEnergyStorage.getEnergyStored());
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)currentEnergyStorage.getMaxEnergyStored());
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (inputItems < 2 || totalCapacity > this.maxCapacity) {
            return ItemStack.field_190927_a;
        }
        energyStorage.setCapacity(totalCapacity);
        ((IEnergyStorageMutable)((Object)energyStorage)).setEnergy(totalEnergy);
        return output;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 9;
    }
}

