/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.ingredient;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackTag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.network.PacketCodec;

public class ItemMatchProperties {
    private final ItemStack itemStack;
    private boolean nbt;
    @Nullable
    private String itemTag;
    private int tagQuantity;

    public ItemMatchProperties(ItemStack itemStack) {
        this(itemStack, false, null, 1);
    }

    public ItemMatchProperties(ItemStack itemStack, boolean nbt, @Nullable String itemTag, int tagQuantity) {
        this.itemStack = itemStack;
        this.nbt = nbt;
        this.itemTag = itemTag;
        this.tagQuantity = tagQuantity;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isNbt() {
        return this.nbt;
    }

    public void setNbt(boolean nbt) {
        this.nbt = nbt;
    }

    @Nullable
    public String getItemTag() {
        return this.itemTag;
    }

    public void setItemTag(@Nullable String itemTag) {
        this.itemTag = itemTag;
    }

    public int getTagQuantity() {
        return this.tagQuantity;
    }

    public void setTagQuantity(int tagQuantity) {
        this.tagQuantity = tagQuantity;
    }

    public boolean isValid() {
        return this.getItemTag() != null || !this.getItemStack().func_190926_b();
    }

    public IPrototypedIngredientAlternatives<ItemStack, Integer> createPrototypedIngredient() {
        if (this.getItemTag() == null) {
            int flags = this.isNbt() ? 5 : 1;
            return new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ITEMSTACK, (Object)this.itemStack, (Object)flags)));
        }
        return new PrototypedIngredientAlternativesItemStackTag(Collections.singletonList(this.getItemTag()), Integer.valueOf(5), (long)this.getTagQuantity());
    }

    static {
        PacketCodec.addCodedAction(ItemMatchProperties.class, (PacketCodec.ICodecAction)new PacketCodec.ICodecAction(){

            public void encode(Object o, PacketBuffer packetBuffer) {
                ItemMatchProperties props = (ItemMatchProperties)o;
                PacketCodec.getAction(ItemStack.class).encode((Object)props.itemStack, packetBuffer);
                packetBuffer.writeBoolean(props.nbt);
                packetBuffer.func_180714_a(props.itemTag != null ? props.itemTag : "");
                packetBuffer.writeInt(props.tagQuantity);
            }

            public Object decode(PacketBuffer packetBuffer) {
                ItemStack itemStack = (ItemStack)PacketCodec.getAction(ItemStack.class).decode(packetBuffer);
                boolean nbt = packetBuffer.readBoolean();
                String itemTag = packetBuffer.func_150789_c(Short.MAX_VALUE);
                int tagQuantity = packetBuffer.readInt();
                return new ItemMatchProperties(itemStack, nbt, itemTag.isEmpty() ? null : itemTag, tagQuantity);
            }
        });
    }
}

